/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks;

import com.westeroscraft.westerosblocks.BlockColoring;
import com.westeroscraft.westerosblocks.Proxy;
import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.commands.PTimeCommand;
import com.westeroscraft.westerosblocks.commands.PWeatherCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientProxy
extends Proxy
implements ISelectiveResourceReloadListener {
    private List<WesterosBlockLifecycle> blocks_to_color = new ArrayList<WesterosBlockLifecycle>();

    @Override
    public void initCleanupHooks() {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void playerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
                WesterosBlocks.log.info("playerLogout");
                PTimeCommand.setTimeOffset(true, 0);
                PWeatherCommand.setWeatherSetting(PWeatherCommand.PWEATHER_SETTING.RESET, null);
            }

            @SubscribeEvent
            public void playerWorldChange(PlayerEvent.PlayerChangedDimensionEvent event) {
                PWeatherCommand.setWeatherSetting(PWeatherCommand.PWEATHER_SETTING.RESET, null);
            }
        });
    }

    @Override
    public void initRenderRegistry() {
    }

    @Override
    public EntityPlayer getPlayerFromNetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String name) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("westerosblocks:" + name)});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("westerosblocks:" + name, "inventory"));
    }

    @Override
    public void registerBlockModels(Block[] blocks) {
        for (Block block : blocks) {
            IBlockColor col;
            if (!(block instanceof WesterosBlockLifecycle)) continue;
            WesterosBlockLifecycle blocklc = (WesterosBlockLifecycle)block;
            IProperty<?>[] ignor = blocklc.getNonRenderingProperties();
            if (ignor != null) {
                StateMap custom_mapper = new StateMap.Builder().func_178442_a(ignor).func_178441_a();
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
            }
            if ((col = blocklc.getBlockColor()) == null) continue;
            this.blocks_to_color.add(blocklc);
        }
    }

    @Override
    public void registerColoring() {
        for (WesterosBlockLifecycle blocklc : this.blocks_to_color) {
            IBlockColor col = blocklc.getBlockColor();
            if (col == null) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a(col, new Block[]{(Block)blocklc});
            Minecraft.func_71410_x().getItemColors().func_186731_a(BlockColoring.BLOCK_ITEM_COLORING, new Block[]{(Block)blocklc});
        }
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pos) : -1;
            }
        }, new Block[]{Blocks.field_150383_bp});
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        WesterosBlocks.log.info("Handling resource reload");
        WesterosBlockDef.reloadColorHandler();
        WesterosBlocks.log.info("Handling resource reload completed");
    }
}

