/*
 * Decompiled with CFR 0.152.
 */
package mrunknown404.unknownlibs.utils;

import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class ColorUtils {
    public static final int RED = ColorUtils.rgba2Int(Color.RED);
    public static final int ORANGE = ColorUtils.rgba2Int(Color.ORANGE);
    public static final int YELLOW = ColorUtils.rgba2Int(Color.YELLOW);
    public static final int GREEN = ColorUtils.rgba2Int(Color.GREEN);
    public static final int CYAN = ColorUtils.rgba2Int(Color.CYAN);
    public static final int BLUE = ColorUtils.rgba2Int(Color.BLUE);
    public static final int PURPLE = ColorUtils.rgba2Int(Color.PURPLE);
    public static final int WHITE = ColorUtils.rgba2Int(Color.WHITE);
    public static final int BLACK = ColorUtils.rgba2Int(Color.BLACK);
    public static final int LIGHT_GREY = ColorUtils.rgba2Int(Color.LTGREY);
    public static final int DARK_GREY = ColorUtils.rgba2Int(Color.DKGREY);
    public static final int GREY = ColorUtils.rgba2Int(Color.GREY);

    public static String addColor(String str) {
        char[] b = str.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || ColorUtils.getAllCodes().indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
        }
        return new String(b);
    }

    public static String getAllCodes() {
        return ColorCodes.getAllColorCodes() + FormatCodes.getAllFormatCodes();
    }

    public static String getRainbowCodes() {
        return "4c6e2ab319d5";
    }

    public static boolean isValidHexColor(String hexColor) {
        if (!hexColor.startsWith("#")) {
            return false;
        }
        if ((hexColor = hexColor.substring(1)).length() == 0 || hexColor.charAt(0) != '-' && Character.digit(hexColor.charAt(0), 16) == -1) {
            return false;
        }
        if (hexColor.length() == 1 && hexColor.charAt(0) == '-') {
            return false;
        }
        for (int i = 1; i < hexColor.length(); ++i) {
            if (Character.digit(hexColor.charAt(i), 16) != -1) continue;
            return false;
        }
        return true;
    }

    public static Color hex2Color(String colorStr) {
        if (!ColorUtils.isValidHexColor(colorStr)) {
            return new Color();
        }
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16).intValue(), Integer.valueOf(colorStr.substring(3, 5), 16).intValue(), Integer.valueOf(colorStr.substring(5, 7), 16).intValue());
    }

    public static int rgba2Int(int r, int g, int b, int a) {
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static int rgba2Int(ReadableColor color) {
        return (color.getAlpha() << 24) + (color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue();
    }

    public static enum FormatCodes {
        BOLD("l"),
        STRIKETHROUGH("m"),
        UNDERLINE("n"),
        ITALIC("o"),
        OBFUSCATED("k"),
        RESET("r");

        public final String code;

        private FormatCodes(String code) {
            this.code = code;
        }

        public static String getAllFormatCodes() {
            StringBuilder sb = new StringBuilder();
            for (FormatCodes f : FormatCodes.values()) {
                sb.append(f.code);
            }
            return sb.toString();
        }
    }

    public static enum ColorCodes {
        DARK_RED("4"),
        RED("c"),
        GOLD("6"),
        YELLOW("e"),
        DARK_GREEN("2"),
        GREEN("a"),
        AQUA("b"),
        DARK_AQUA("3"),
        DARK_BLUE("1"),
        BLUE("9"),
        LIGHT_PURPLE("d"),
        DARK_PURPLE("5"),
        WHITE("f"),
        GRAY("7"),
        DARK_GRAY("8"),
        BLACK("9");

        public final String code;

        private ColorCodes(String code) {
            this.code = code;
        }

        public static String getAllColorCodes() {
            StringBuilder sb = new StringBuilder();
            for (ColorCodes c : ColorCodes.values()) {
                sb.append(c.code);
            }
            return sb.toString();
        }
    }
}

