/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;

public class AudioUtil {
    public static final AudioFormat FORMAT = new AudioFormat(48000.0f, 16, 2, true, false);

    public static Mixer findMixer(String name, Line.Info lineInfo) {
        Mixer defaultMixer = null;
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo)) continue;
            if (mixerInfo.getName().equals(name)) {
                return mixer;
            }
            if (defaultMixer != null) continue;
            defaultMixer = mixer;
        }
        return defaultMixer;
    }

    public static List<String> findAudioDevices(Line.Info lineInfo) {
        ArrayList<String> list = new ArrayList<String>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo)) continue;
            list.add(mixerInfo.getName());
        }
        return list;
    }

    public static boolean hasLinesOpen(Mixer mixer) {
        return mixer.getSourceLines().length != 0 || mixer.getTargetLines().length != 0;
    }

    public static int calculateVolumeMultiplier(int volume) {
        return (int)((float)Math.tan((float)volume * 0.0079f) * 10000.0f);
    }

    public static void changeVolume(byte[] pcm, int volume, int multiplier) {
        if (volume == 100) {
            return;
        }
        AudioUtil.changeVolume(pcm, multiplier);
    }

    public static void changeVolume(byte[] pcm, int multiplier) {
        ShortBuffer buffer = ByteBuffer.wrap(pcm).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        for (int index = buffer.position(); index < buffer.limit(); ++index) {
            buffer.put(index, (short)Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, buffer.get(index) * multiplier / 10000)));
        }
    }

    public static byte[] adjustVolume(byte[] audioSamples, float volume) {
        byte[] array = new byte[audioSamples.length];
        for (int i = 0; i < array.length; i += 2) {
            short buf1 = audioSamples[i + 1];
            short buf2 = audioSamples[i];
            buf1 = (short)((buf1 & 0xFF) << 8);
            buf2 = (short)(buf2 & 0xFF);
            short res = (short)(buf1 | buf2);
            res = (short)((float)res * volume);
            array[i] = (byte)res;
            array[i + 1] = (byte)(res >> 8);
        }
        return array;
    }

    public static double calculateRms(byte[] samples) {
        double sumOfSampleSq = 0.0;
        double peakSample = 0.0;
        byte[] byArray = samples;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            short sample = byArray[i];
            double normSample = (double)sample / 32767.0;
            sumOfSampleSq += normSample * normSample;
            if (!((double)Math.abs(sample) > peakSample)) continue;
            peakSample = Math.abs(sample);
        }
        double rms = 10.0 * Math.log10(sumOfSampleSq / (double)samples.length);
        double peak = 20.0 * Math.log10(peakSample / 32767.0);
        return rms;
    }

    public static short[] bytesToShorts(byte[] bytes) {
        short[] shorts = new short[bytes.length / 2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
        return shorts;
    }

    public static byte[] shortsToBytes(short[] shorts) {
        byte[] bytes2 = new byte[shorts.length * 2];
        ByteBuffer.wrap(bytes2).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(shorts);
        return bytes2;
    }

    public static float getdB(byte[] buffer) {
        double dB = 0.0;
        short[] shortArray = new short[buffer.length / 2];
        ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shortArray);
        for (int i = 0; i < shortArray.length; ++i) {
            dB = 20.0 * Math.log10(Math.abs((double)shortArray[i] / 32767.0));
            if (dB != Double.NEGATIVE_INFINITY && dB != Double.NaN) continue;
            dB = -90.0;
        }
        float level = (float)dB;
        return level;
    }
}

