/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.server;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Server;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import fr.nathanael2611.modularvoicechat.api.VoiceServerStartEvent;
import fr.nathanael2611.modularvoicechat.api.dispatcher.IVoiceDispatcher;
import fr.nathanael2611.modularvoicechat.config.ServerConfig;
import fr.nathanael2611.modularvoicechat.network.objects.KryoObjects;
import fr.nathanael2611.modularvoicechat.server.KryoNetServerListener;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class VoiceServer {
    public final HashBiMap<Integer, Connection> CONNECTIONS_MAP = HashBiMap.create();
    private IVoiceDispatcher dispatcher;
    private int port;
    private Server server;

    VoiceServer() {
        this.port = ServerConfig.generalConfig.port;
        this.dispatcher = ServerConfig.generalConfig.dispatcher.createDispatcher();
        VoiceServerStartEvent event = new VoiceServerStartEvent(this, this.dispatcher);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getVoiceDispatcher() != this.dispatcher) {
            this.dispatcher = event.getVoiceDispatcher();
        }
        this.server = new Server(10000000, 10000000);
        KryoObjects.registerObjects(this.server.getKryo());
        this.server.start();
        try {
            this.server.bind(this.port, this.port);
            this.server.addListener(new KryoNetServerListener(this));
            Helpers.log("Successfully started VoiceServer.");
        }
        catch (IOException e) {
            e.printStackTrace();
            Helpers.log("Failed to start VoiceServer.");
        }
    }

    public void sendToAllExcept(EntityPlayerMP except, Object obj) {
        for (Map.Entry connectionsEntry : this.CONNECTIONS_MAP.entrySet()) {
            if (except != null && ((Integer)connectionsEntry.getKey()).intValue() == except.func_145782_y() || connectionsEntry.getValue() == null) continue;
            ((Connection)connectionsEntry.getValue()).sendUDP(obj);
        }
    }

    public void send(EntityPlayerMP dest, Object obj) {
        Connection connection = this.getPlayerConnection((EntityPlayer)dest);
        if (connection != null) {
            connection.sendUDP(obj);
        }
    }

    public boolean isPlayerConnected(EntityPlayer player) {
        return this.getPlayerConnection(player) != null;
    }

    public Connection getPlayerConnection(EntityPlayer player) {
        return player == null ? null : (Connection)this.CONNECTIONS_MAP.get((Object)player.func_145782_y());
    }

    public boolean hasAssignedPlayer(Connection connection) {
        return this.getPlayer(connection) != null;
    }

    public EntityPlayerMP getPlayer(Connection connection) {
        return Helpers.getPlayerByEntityId((Integer)this.CONNECTIONS_MAP.inverse().getOrDefault((Object)connection, (Object)-1));
    }

    public void close() {
        this.server.close();
        Helpers.log("Successfully closed VoiceServer.");
    }

    public int getPort() {
        return this.port;
    }

    public List<EntityPlayerMP> getConnectedPlayers() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : this.CONNECTIONS_MAP.inverse().entrySet()) {
            EntityPlayerMP player = Helpers.getPlayerByEntityId((Integer)entry.getValue());
            Connection conn = (Connection)entry.getKey();
            if (player == null || conn == null || !conn.isConnected()) continue;
            list.add(player);
        }
        return list;
    }

    public IVoiceDispatcher getVoiceDispatcher() {
        return this.dispatcher;
    }
}

