/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.server;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.google.common.collect.BiMap;
import fr.nathanael2611.modularvoicechat.api.VoiceDispatchEvent;
import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import fr.nathanael2611.modularvoicechat.network.objects.HelloImAPlayer;
import fr.nathanael2611.modularvoicechat.network.objects.HelloYouAreAPlayer;
import fr.nathanael2611.modularvoicechat.network.objects.VoiceEndToClient;
import fr.nathanael2611.modularvoicechat.network.objects.VoiceEndToServer;
import fr.nathanael2611.modularvoicechat.network.objects.VoiceToServer;
import fr.nathanael2611.modularvoicechat.proxy.CommonProxy;
import fr.nathanael2611.modularvoicechat.server.VoiceServer;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class KryoNetServerListener
extends Listener {
    private VoiceServer voiceServer;

    KryoNetServerListener(VoiceServer server) {
        this.voiceServer = server;
    }

    @Override
    public void disconnected(Connection connection) {
        super.disconnected(connection);
        BiMap map = this.voiceServer.CONNECTIONS_MAP.inverse();
        if (map.containsKey((Object)connection)) {
            this.voiceServer.CONNECTIONS_MAP.remove(map.get((Object)connection));
        }
    }

    @Override
    public void received(Connection connection, Object object) {
        EntityPlayerMP player = this.voiceServer.getPlayer(connection);
        if (object instanceof HelloImAPlayer) {
            HelloImAPlayer hello = (HelloImAPlayer)object;
            Helpers.log("A new player tried to connect to VoiceServer named: " + hello.playerName);
            EntityPlayerMP playerMP = Helpers.getPlayerByUsername(hello.playerName);
            if (playerMP != null) {
                this.voiceServer.CONNECTIONS_MAP.put((Object)playerMP.func_145782_y(), (Object)connection);
                Helpers.log("Successfully added " + hello.playerName + " to voice-server connected-players!");
                connection.sendTCP(new HelloYouAreAPlayer());
            } else {
                Helpers.log("No player named: " + hello.playerName);
            }
        } else if (player != null) {
            if (object instanceof VoiceToServer) {
                if (!CommonProxy.getMutedPlayers().isMuted(player.func_70005_c_())) {
                    VoiceToServer voiceToServer = (VoiceToServer)object;
                    VoiceDispatchEvent event = new VoiceDispatchEvent(this.voiceServer, player, voiceToServer.opusBytes, VoiceProperties.empty());
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled()) {
                        event.getVoiceServer().getVoiceDispatcher().dispatch(event);
                    }
                    event.finalizeDispatch();
                } else {
                    SPacketTitle spackettitle1 = new SPacketTitle(SPacketTitle.Type.ACTIONBAR, (ITextComponent)new TextComponentTranslation("mvc.error.muted", new Object[0]), 1, 1, 1);
                    player.field_71135_a.func_147359_a((Packet)spackettitle1);
                }
            } else if (object instanceof VoiceEndToServer) {
                this.voiceServer.sendToAllExcept(player, new VoiceEndToClient(player.func_145782_y()));
            }
        }
        super.received(connection, object);
    }
}

