/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.network.vanilla;

import fr.nathanael2611.modularvoicechat.client.ClientEventHandler;
import fr.nathanael2611.modularvoicechat.client.voice.VoiceClientManager;
import fr.nathanael2611.modularvoicechat.client.voice.audio.MicroManager;
import fr.nathanael2611.modularvoicechat.client.voice.audio.SpeakerManager;
import fr.nathanael2611.modularvoicechat.util.Helpers;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketConnectVoice
implements IMessage {
    private String ip;
    private int port;
    private String playerName;
    private boolean showWhoSpeak;

    public PacketConnectVoice() {
    }

    public PacketConnectVoice(String ip, int port, String playerName, boolean showWhoSpeak) {
        this.ip = ip;
        this.port = port;
        this.playerName = playerName;
        this.showWhoSpeak = showWhoSpeak;
    }

    public void fromBytes(ByteBuf buf) {
        this.ip = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.port = buf.readInt();
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.showWhoSpeak = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ip);
        buf.writeInt(this.port);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        buf.writeBoolean(this.showWhoSpeak);
    }

    public static String getHostName(InetSocketAddress rescue) {
        ServerData serverData = Minecraft.func_71410_x().func_147104_D();
        if (serverData != null) {
            return serverData.field_78845_b.split(":")[0];
        }
        String host = rescue.getHostName();
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public static class Message
    implements IMessageHandler<PacketConnectVoice, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketConnectVoice message, MessageContext ctx) {
            if (ctx.getClientHandler().func_147298_b().func_74430_c() instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)ctx.getClientHandler().func_147298_b().func_74430_c();
                String host = message.ip.length() > 0 ? message.ip : PacketConnectVoice.getHostName(address);
                Helpers.log("Receiving voice-connect packet from server: " + host);
                new Thread(() -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Helpers.log("Connected to a Minecraft Server, trying to handle voice connection.");
                    if (VoiceClientManager.isStarted()) {
                        VoiceClientManager.stop();
                    }
                    if (MicroManager.isRunning()) {
                        MicroManager.stop();
                    }
                    if (SpeakerManager.isRunning()) {
                        SpeakerManager.stop();
                    }
                    Helpers.log("[pre] Handle VoiceClient start.");
                    VoiceClientManager.start(message.playerName, host, message.port);
                    MicroManager.start();
                    SpeakerManager.start();
                    ClientEventHandler.showWhoSpeak = message.showWhoSpeak;
                }).start();
            }
            return null;
        }
    }
}

