/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fr.nathanael2611.modularvoicechat.config.ConfigProperty;
import fr.nathanael2611.modularvoicechat.config.GameConfig;
import java.io.File;
import java.io.IOException;

public class ClientConfig
extends GameConfig {
    public static final ConfigProperty MICROPHONE = new ConfigProperty("microphone", (JsonElement)new JsonPrimitive(""));
    public static final ConfigProperty MICROPHONE_VOLUME = new ConfigProperty("microphoneVolume", (JsonElement)new JsonPrimitive((Number)100));
    public static final ConfigProperty SPEAKER = new ConfigProperty("speaker", (JsonElement)new JsonPrimitive(""));
    public static final ConfigProperty SPEAKER_VOLUME = new ConfigProperty("speakerVolume", (JsonElement)new JsonPrimitive((Number)100));
    public static final ConfigProperty BITRATE = new ConfigProperty("bitrate", (JsonElement)new JsonPrimitive((Number)96000));
    public static final ConfigProperty TOGGLE_TO_TALK = new ConfigProperty("toggle-to-talk", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
    public static final ConfigProperty STEREO = new ConfigProperty("stereo", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));

    public ClientConfig(File config) {
        super(config);
        if (!config.exists()) {
            try {
                config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void read() throws IOException {
        super.read();
        this.initProperty(MICROPHONE);
        this.initProperty(MICROPHONE_VOLUME);
        this.initProperty(SPEAKER);
        this.initProperty(SPEAKER_VOLUME);
        this.initProperty(BITRATE);
        this.initProperty(TOGGLE_TO_TALK);
        this.initProperty(STEREO);
    }

    public boolean isStereo() {
        return this.get(STEREO).getAsBoolean();
    }
}

