/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.audio.speaker;

import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import fr.nathanael2611.modularvoicechat.audio.api.NoExceptionCloseable;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerBufferPusher;
import fr.nathanael2611.modularvoicechat.audio.speaker.SpeakerData;
import fr.nathanael2611.modularvoicechat.util.ThreadUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SpeakerPlayer
implements NoExceptionCloseable {
    private final ExecutorService executor = Executors.newCachedThreadPool(ThreadUtil.createDaemonFactory("speaker player"));
    private final SpeakerData speakerData;
    private final Map<Integer, SpeakerBufferPusher> bufferMap;

    public SpeakerPlayer(SpeakerData speakerData) {
        this.speakerData = speakerData;
        this.bufferMap = new HashMap<Integer, SpeakerBufferPusher>();
    }

    public void accept(int id, byte[] opusPacket, int volumePercent, VoiceProperties properties) {
        if (this.speakerData.isAvailable(id)) {
            if (opusPacket == null) {
                this.bufferMap.computeIfAbsent(id, $ -> new SpeakerBufferPusher(this.executor, id, this.speakerData)).end();
            } else {
                this.bufferMap.computeIfAbsent(id, $ -> new SpeakerBufferPusher(this.executor, id, this.speakerData)).decodePush(opusPacket, volumePercent, properties);
            }
        }
    }

    @Override
    public void close() {
        this.bufferMap.values().forEach(SpeakerBufferPusher::close);
        this.bufferMap.clear();
        this.executor.shutdown();
    }
}

