/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.audio.speaker;

import fr.nathanael2611.modularvoicechat.api.VoiceProperties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SpeakerBuffer {
    private final BlockingQueue<AudioEntry> queue;

    SpeakerBuffer(int size) {
        this.queue = new LinkedBlockingQueue<AudioEntry>(size);
    }

    public AudioEntry getNextPacket() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException ex) {
            throw new AssertionError();
        }
    }

    public void pushPacket(byte[] packet, int volumePercent, VoiceProperties properties) {
        AudioEntry entry = new AudioEntry(packet, volumePercent, properties);
        if (!this.queue.offer(entry)) {
            this.queue.poll();
            this.queue.offer(entry);
        }
    }

    public void pushEnd() {
        AudioEntry entry = new AudioEntry(true);
        if (!this.queue.offer(entry)) {
            this.queue.poll();
            this.queue.offer(entry);
        }
    }

    static class AudioEntry {
        private byte[] packet;
        private int volumePercent;
        private VoiceProperties properties;
        private boolean end;

        AudioEntry(byte[] packet, int volumePercent, VoiceProperties properties) {
            this.packet = packet;
            this.volumePercent = volumePercent;
            this.properties = properties;
        }

        AudioEntry(boolean end) {
            this.end = end;
            this.packet = null;
            this.volumePercent = 0;
            this.properties = null;
        }

        public boolean isEnd() {
            return this.end;
        }

        int getVolumePercent() {
            return this.volumePercent;
        }

        byte[] getPacket() {
            return this.packet;
        }

        VoiceProperties getProperties() {
            return this.properties;
        }
    }
}

