/*
 * Decompiled with CFR 0.152.
 */
package fr.nathanael2611.modularvoicechat.audio.micro;

import fr.nathanael2611.modularvoicechat.api.VoiceRecordedEvent;
import fr.nathanael2611.modularvoicechat.audio.api.IAudioEncoder;
import fr.nathanael2611.modularvoicechat.audio.api.NoExceptionCloseable;
import fr.nathanael2611.modularvoicechat.audio.impl.OpusEncoder;
import fr.nathanael2611.modularvoicechat.audio.micro.MicroData;
import fr.nathanael2611.modularvoicechat.util.ThreadUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MicroRecorder
implements NoExceptionCloseable {
    private final ExecutorService executor = Executors.newSingleThreadExecutor(ThreadUtil.createDaemonFactory("micro recorder"));
    private final MicroData microData;
    private final Consumer<byte[]> opusPacketConsumer;
    private final IAudioEncoder encoder;
    private volatile boolean send;

    public MicroRecorder(MicroData microData, Consumer<byte[]> opusPacketConsumer, int bitrate) {
        this.microData = microData;
        this.opusPacketConsumer = opusPacketConsumer;
        this.encoder = new OpusEncoder(48000, 2, 20, bitrate, 0, 1000);
    }

    public void start() {
        if (this.send || !this.microData.isAvailable()) {
            return;
        }
        this.send = true;
        this.executor.execute(() -> {
            byte[] buffer = new byte[3840];
            while (this.send && this.microData.isAvailable()) {
                byte[] samples = this.microData.read(buffer);
                VoiceRecordedEvent event = new VoiceRecordedEvent(samples);
                MinecraftForge.EVENT_BUS.post((Event)event);
                byte[] recordedSamples = event.getRecordedSamples();
                if (event.isCanceled()) continue;
                this.opusPacketConsumer.accept(this.encoder.encode(recordedSamples));
            }
            ThreadUtil.execute(10, 20, () -> this.opusPacketConsumer.accept(this.encoder.silence()));
        });
    }

    public void stop() {
        this.send = false;
        this.microData.flush();
    }

    public boolean isSending() {
        return this.send;
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.encoder.close();
    }
}

