#version 120

uniform int time;
uniform float disfiguration;

varying vec3 vNormal;
varying vec2 vTexCoord;
varying vec3 vPosition;

void main() {
    // Get the original vertex position and normal
    vec3 position = gl_Vertex.xyz;
    vec3 normal = normalize(gl_Normal);

    // Apply a subtle wave-like displacement based on time and disfiguration
    float timeFloat = float(time) * 0.02; // Smoother time factor
    float noiseX = sin(position.x * 2.0 + timeFloat) * sin(position.z * 3.0 + timeFloat * 1.3);
    float noiseY = sin(position.y * 2.5 + timeFloat * 0.7) * sin(position.x * 2.0 + timeFloat * 0.9);
    float noiseZ = sin(position.z * 3.0 + timeFloat * 1.1) * sin(position.y * 2.7 + timeFloat * 0.8);

    // Create displacement vector
    vec3 displacement = normal * vec3(noiseX, noiseY, noiseZ) * disfiguration;

    // Apply displacement to position
    vec3 newPosition = position + displacement;

    // Pass values to fragment shader
    vNormal = gl_NormalMatrix * normal;
    vTexCoord = gl_MultiTexCoord0.xy;
    vPosition = newPosition;

    // Forward the original color to the fragment shader
    gl_FrontColor = gl_Color;

    // Set final position
    gl_Position = gl_ModelViewProjectionMatrix * vec4(newPosition, 1.0);
}