/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.events;

import fr.minepiece.common.handlers.PlayerKOHandler;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.MobEffects;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.SERVER})
public class PlayerKOEventRedirect {
    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        DamageSource damageSrc = event.getSource();
        float damageAmount = event.getAmount();
        damageAmount = PlayerKOEventRedirect.applyArmorCalculations(damageSrc, damageAmount, entityLivingBase);
        damageAmount = PlayerKOEventRedirect.applyPotionDamageCalculations(damageSrc, damageAmount, entityLivingBase);
        damageAmount = Math.max(damageAmount - entityLivingBase.func_110139_bj(), 0.0f);
        LivingDamageEvent lvigindmgEvent = new LivingDamageEvent(entityLivingBase, damageSrc, damageAmount);
        PlayerKOHandler.onPlayerDamage(lvigindmgEvent);
        if (lvigindmgEvent.isCanceled()) {
            event.setCanceled(true);
        }
    }

    protected static float applyArmorCalculations(DamageSource source, float damage, EntityLivingBase entityLivingBase) {
        if (!source.func_76363_c()) {
            damage = CombatRules.func_189427_a((float)damage, (float)entityLivingBase.func_70658_aO(), (float)((float)entityLivingBase.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        }
        return damage;
    }

    protected static float applyPotionDamageCalculations(DamageSource source, float damage, EntityLivingBase entityLivingBase) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (entityLivingBase.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (entityLivingBase.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)entityLivingBase.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }
}

