/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.events;

import fr.minepiece.common.capability.mpcooldowns.DefaultMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import fr.minepiece.common.capability.mpdata.DefaultMinePieceData;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.DefaultMinePieceStats;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import fr.minepiece.common.capability.playermodifications.DefaultPlayerModifications;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import fr.minepiece.common.capability.thirst.DefaultThirst;
import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.FullModificationsPacket;
import fr.minepiece.common.network.packets.TextureRecomputePacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="minepiece")
public class MinePieceServerEvents {
    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone e) {
        if (e.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        MinePieceServerEvents.syncPlayerData(e.getOriginal(), e.getEntityPlayer());
        if (e.getEntityPlayer() instanceof EntityPlayerMP) {
            MinePieceServerEvents.syncToAllPlayers((EntityPlayerMP)e.getEntityPlayer());
            MinePieceServerEvents.initPlayerRace(e.getEntityPlayer());
        }
    }

    private static void syncPlayerData(EntityPlayer original, EntityPlayer newPlayer) {
        IMinePieceData oldData = (IMinePieceData)original.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        IMinePieceData data = (IMinePieceData)newPlayer.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (oldData != null && data != null) {
            DefaultMinePieceData.syncStats(oldData, data);
        }
        IMinePieceStats oldStats = (IMinePieceStats)original.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        IMinePieceStats stats = (IMinePieceStats)newPlayer.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        if (oldStats != null && stats != null) {
            DefaultMinePieceStats.syncStats(oldStats, stats);
        }
        IMinePieceCooldown oldCooldown = (IMinePieceCooldown)original.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
        IMinePieceCooldown cooldown = (IMinePieceCooldown)newPlayer.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
        if (oldCooldown != null && cooldown != null) {
            DefaultMinePieceCooldown.syncStats(oldCooldown, cooldown);
        }
        IPlayerModifications oldModifications = (IPlayerModifications)original.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        IPlayerModifications modifications = (IPlayerModifications)newPlayer.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (oldModifications != null && modifications != null) {
            DefaultPlayerModifications.syncStats(oldModifications, modifications);
        }
        IThirst oldThirst = (IThirst)original.getCapability(ThirstProvider.THIRST_CAPABILITY, null);
        IThirst thirst = (IThirst)newPlayer.getCapability(ThirstProvider.THIRST_CAPABILITY, null);
        if (oldThirst != null && thirst != null) {
            DefaultThirst.syncStats(oldThirst, thirst);
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            MinePieceServerEvents.syncToAllPlayers(player);
            ModPackets.NETWORK.sendTo((IMessage)new TextureRecomputePacket(), player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            MinePieceServerEvents.syncToAllPlayers((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onEntityTrack(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayerMP) {
            EntityPlayerMP trackedPlayer = (EntityPlayerMP)event.getTarget();
            EntityPlayerMP trackingPlayer = (EntityPlayerMP)event.getEntityPlayer();
            MinePieceServerEvents.syncToClient(trackedPlayer, trackingPlayer);
            ModPackets.NETWORK.sendTo((IMessage)new TextureRecomputePacket(), trackingPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.field_72995_K) {
                MinePieceServerEvents.syncToAllPlayers((EntityPlayerMP)player);
                MinePieceServerEvents.syncExistingPlayersToNewPlayer((EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayerMP joinedPlayer = (EntityPlayerMP)event.player;
        MinePieceServerEvents.initPlayerRace((EntityPlayer)joinedPlayer);
        MinePieceServerEvents.syncToAllPlayers(joinedPlayer);
        MinePieceServerEvents.syncExistingPlayersToNewPlayer(joinedPlayer);
    }

    private static void syncToAllPlayers(EntityPlayerMP sourcePlayer) {
        IMinePieceData data = (IMinePieceData)sourcePlayer.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        IMinePieceStats stats = (IMinePieceStats)sourcePlayer.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        IPlayerModifications modifications = (IPlayerModifications)sourcePlayer.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        IThirst thirst = (IThirst)sourcePlayer.getCapability(ThirstProvider.THIRST_CAPABILITY, null);
        if (data != null) {
            data.clientSync(sourcePlayer);
        }
        if (stats != null) {
            stats.clientSync(sourcePlayer);
        }
        if (modifications != null) {
            modifications.clientSync(sourcePlayer);
        }
        if (thirst != null) {
            thirst.clientSync(sourcePlayer);
        }
    }

    private static void syncExistingPlayersToNewPlayer(EntityPlayerMP newPlayer) {
        for (EntityPlayerMP existingPlayer : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            IPlayerModifications existingData;
            if (existingPlayer == newPlayer || (existingData = (IPlayerModifications)existingPlayer.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null)) == null) continue;
            ModPackets.NETWORK.sendTo((IMessage)new FullModificationsPacket(existingData.getModifications(), existingData.getSkinModifications(), existingData.getPose(), existingData.getSkin(), existingData.getSkinColor(), existingData.getModificationColor(), existingPlayer.func_110124_au()), newPlayer);
        }
    }

    private static void syncToClient(EntityPlayerMP trackedPlayer, EntityPlayerMP trackingPlayer) {
        IPlayerModifications modifications = (IPlayerModifications)trackedPlayer.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        if (modifications != null) {
            ModPackets.NETWORK.sendTo((IMessage)new FullModificationsPacket(modifications.getModifications(), modifications.getSkinModifications(), modifications.getPose(), modifications.getSkin(), modifications.getSkinColor(), modifications.getModificationColor(), trackedPlayer.func_110124_au()), trackingPlayer);
        }
    }

    private static void initPlayerRace(EntityPlayer player) {
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data != null) {
            data.getRace().getInstance().init(player, player.field_70170_p);
        }
    }
}

