/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.utils.XPConfigManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class XPInfoCommand
extends CommandBase {
    public String func_71517_b() {
        return "Minepiece_xp_info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_xp_info";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        this.displayXPInfo(sender);
    }

    private void displayXPInfo(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Informations XP ==="));
        int interval = XPConfigManager.getSecondsBetweenPassiveXP();
        int amount = XPConfigManager.getPassiveXPAmount();
        int xpPerHour = 3600 / interval * amount;
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Intervalle entre gains: " + interval + " secondes"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Quantit\u00e9 d'XP par gain: " + amount + " XP"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "XP par heure (estim\u00e9e): " + xpPerHour + " XP"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "XP de job activ\u00e9e: " + (XPConfigManager.isGiveJobXP() ? TextFormatting.GREEN + "OUI" : TextFormatting.RED + "NON")));
    }

    private int estimateTimeToLevel(int level, int xpPerHour) {
        if (xpPerHour <= 0) {
            return 9999;
        }
        int totalXpNeeded = 5 * level * level;
        return (int)Math.ceil((double)totalXpNeeded / (double)xpPerHour);
    }

    private String formatHours(int hours) {
        if (hours < 1) {
            return "moins d'une heure";
        }
        if (hours < 24) {
            return hours + " heure" + (hours > 1 ? "s" : "");
        }
        int days = hours / 24;
        int remainingHours = hours % 24;
        return days + " jour" + (days > 1 ? "s" : "") + (remainingHours > 0 ? " " + remainingHours + " heure" + (remainingHours > 1 ? "s" : "") : "");
    }
}

