/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.utils.XPConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class XPConfigCommand
extends CommandBase {
    public String func_71517_b() {
        return "Minepiece_xp_config";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_xp_config <interval|amount|jobtoggle|save|load> [value]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subCommand;
        if (args.length < 1) {
            this.displayAllInfo(sender);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "interval": {
                if (args.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Intervalle actuel: " + XPConfigManager.getSecondsBetweenPassiveXP() + " secondes"));
                    break;
                }
                this.handleIntervalConfig(sender, XPConfigCommand.func_175755_a((String)args[1]));
                break;
            }
            case "amount": {
                if (args.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Quantit\u00e9 actuelle: " + XPConfigManager.getPassiveXPAmount() + " XP"));
                    break;
                }
                this.handleAmountConfig(sender, XPConfigCommand.func_175755_a((String)args[1]));
                break;
            }
            case "jobtoggle": {
                this.handleJobToggle(sender);
                break;
            }
            case "save": {
                XPConfigManager.saveConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Configuration XP sauvegard\u00e9e dans le fichier"));
                break;
            }
            case "load": {
                XPConfigManager.loadConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Configuration XP charg\u00e9e depuis le fichier"));
                break;
            }
            default: {
                this.displayAllInfo(sender);
            }
        }
    }

    private void displayAllInfo(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Configuration XP ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Intervalle entre gains: " + XPConfigManager.getSecondsBetweenPassiveXP() + " secondes"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Quantit\u00e9 d'XP passive: " + XPConfigManager.getPassiveXPAmount() + " XP"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "XP de job activ\u00e9e: " + (XPConfigManager.isGiveJobXP() ? TextFormatting.GREEN + "OUI" : TextFormatting.RED + "NON")));
    }

    private void handleIntervalConfig(ICommandSender sender, int seconds) throws CommandException {
        if (seconds < 1) {
            throw new CommandException("L'intervalle doit \u00eatre d'au moins 1 seconde", new Object[0]);
        }
        XPConfigManager.setSecondsBetweenPassiveXP(seconds);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Intervalle entre gains d'XP passive r\u00e9gl\u00e9 \u00e0 " + seconds + " secondes"));
    }

    private void handleAmountConfig(ICommandSender sender, int amount) throws CommandException {
        if (amount < 0) {
            throw new CommandException("La quantit\u00e9 d'XP doit \u00eatre positive ou nulle", new Object[0]);
        }
        XPConfigManager.setPassiveXPAmount(amount);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 d'XP passive r\u00e9gl\u00e9e \u00e0 " + amount + " XP"));
    }

    private void handleJobToggle(ICommandSender sender) {
        boolean newState = XPConfigManager.toggleGiveJobXP();
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Gain d'XP de m\u00e9tier " + (newState ? TextFormatting.GREEN + "ACTIV\u00c9" : TextFormatting.RED + "D\u00c9SACTIV\u00c9")));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("interval");
            completions.add("amount");
            completions.add("jobtoggle");
            completions.add("save");
            completions.add("load");
        }
        return XPConfigCommand.func_175762_a((String[])args, completions);
    }
}

