/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.utils.TemperatureZoneSyncManager;
import fr.minepiece.common.utils.TemperatureZones;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TemperatureZoneCommand
extends CommandBase {
    public String func_71517_b() {
        return "Minepiece_temp_zone";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_temp_zone <create|remove|list|info|clear> [params...]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subCommand;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(sender, args);
                break;
            }
            case "remove": {
                this.handleRemove(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender, args);
                break;
            }
            case "info": {
                this.handleInfo(sender, args);
                break;
            }
            case "clear": {
                this.handleClear(sender);
                break;
            }
            default: {
                throw new WrongUsageException("Sous-commande inconnue: " + subCommand, new Object[0]);
            }
        }
    }

    private void handleCreate(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 7) {
            throw new WrongUsageException("/Minepiece_temp_zone create <nom> <x1> <y1> <z1> <x2> <y2> <z2> <temp\u00e9rature> [rayon_blend=5] [priorit\u00e9=10]", new Object[0]);
        }
        String name = args[1];
        try {
            int x1 = TemperatureZoneCommand.func_175755_a((String)args[2]);
            int y1 = TemperatureZoneCommand.func_175755_a((String)args[3]);
            int z1 = TemperatureZoneCommand.func_175755_a((String)args[4]);
            int x2 = TemperatureZoneCommand.func_175755_a((String)args[5]);
            int y2 = TemperatureZoneCommand.func_175755_a((String)args[6]);
            int z2 = TemperatureZoneCommand.func_175755_a((String)args[7]);
            double temperature = TemperatureZoneCommand.func_175765_c((String)args[8]);
            double blendRadius = args.length > 9 ? TemperatureZoneCommand.func_175765_c((String)args[9]) : 5.0;
            double priority = args.length > 10 ? TemperatureZoneCommand.func_175765_c((String)args[10]) : 10.0;
            BlockPos minPos = new BlockPos(x1, y1, z1);
            BlockPos maxPos = new BlockPos(x2, y2, z2);
            TemperatureZones.TemperatureZone zone = new TemperatureZones.TemperatureZone(name, minPos, maxPos, temperature, blendRadius, priority);
            int dimension = sender.func_130014_f_().field_73011_w.getDimension();
            boolean success = TemperatureZones.addZone(dimension, zone);
            if (success) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Zone de temp\u00e9rature '" + name + "' cr\u00e9\u00e9e avec succ\u00e8s dans la dimension " + dimension));
                if (sender instanceof EntityPlayerMP) {
                    TemperatureZones.visualizeZone((EntityPlayerMP)sender, zone, 400);
                }
                TemperatureZoneSyncManager.onZoneAdded(dimension);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Une zone avec le nom '" + name + "' existe d\u00e9j\u00e0 dans cette dimension"));
            }
        }
        catch (NumberFormatException e) {
            throw new CommandException("Erreur de format num\u00e9rique: " + e.getMessage(), new Object[0]);
        }
    }

    private void handleRemove(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException("/Minepiece_temp_zone remove <nom>", new Object[0]);
        }
        String name = args[1];
        int dimension = sender.func_130014_f_().field_73011_w.getDimension();
        boolean success = TemperatureZones.removeZone(dimension, name);
        if (success) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Zone de temp\u00e9rature '" + name + "' supprim\u00e9e avec succ\u00e8s"));
            TemperatureZoneSyncManager.onZoneRemoved(dimension);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Aucune zone de temp\u00e9rature nomm\u00e9e '" + name + "' trouv\u00e9e dans cette dimension"));
        }
    }

    private void handleList(ICommandSender sender, String[] args) {
        List<TemperatureZones.TemperatureZone> zones;
        int dimension = sender.func_130014_f_().field_73011_w.getDimension();
        if (args.length > 1) {
            try {
                dimension = TemperatureZoneCommand.func_175755_a((String)args[1]);
            }
            catch (NumberFormatException | NumberInvalidException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Format de dimension invalide: " + args[1]));
                return;
            }
        }
        if ((zones = TemperatureZones.getZonesForDimension(dimension)).isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Aucune zone de temp\u00e9rature d\u00e9finie dans la dimension " + dimension));
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Zones de temp\u00e9rature dans la dimension " + dimension + ":"));
        for (TemperatureZones.TemperatureZone zone : zones) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "- " + zone.getName() + ": " + String.format("%.1f\u00b0C", zone.getTemperature()) + " (priorit\u00e9: " + zone.getPriority() + ")"));
        }
    }

    private void handleInfo(ICommandSender sender, String[] args) throws CommandException {
        int dimension = sender.func_130014_f_().field_73011_w.getDimension();
        if (args.length == 1) {
            if (!(sender instanceof EntityPlayer)) {
                throw new CommandException("Cette commande doit \u00eatre ex\u00e9cut\u00e9e par un joueur ou avec un nom de zone", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)sender;
            List<Map.Entry<TemperatureZones.TemperatureZone, Double>> zones = TemperatureZones.getInfluencingZones(player.field_70170_p, player.func_180425_c());
            if (zones.isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Aucune zone de temp\u00e9rature \u00e0 votre position actuelle"));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Zones de temp\u00e9rature \u00e0 votre position:"));
            for (Map.Entry<TemperatureZones.TemperatureZone, Double> entry : zones) {
                TemperatureZones.TemperatureZone zone = entry.getKey();
                double influence = entry.getValue();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "- " + zone.getName() + ": " + String.format("%.1f\u00b0C", zone.getTemperature()) + " (influence: " + String.format("%.1f%%", influence * 100.0) + ")"));
            }
            double zoneTemp = TemperatureZones.getZoneTemperature(player.field_70170_p, player.func_180425_c(), 20.0);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Temp\u00e9rature r\u00e9sultante: " + String.format("%.1f\u00b0C", zoneTemp)));
            return;
        }
        if (args.length >= 2) {
            String name = args[1];
            if (args.length > 2) {
                try {
                    dimension = TemperatureZoneCommand.func_175755_a((String)args[2]);
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Format de dimension invalide: " + args[2]));
                    return;
                }
            }
            List<TemperatureZones.TemperatureZone> zones = TemperatureZones.getZonesForDimension(dimension);
            for (TemperatureZones.TemperatureZone zone : zones) {
                if (!zone.getName().equals(name)) continue;
                BlockPos min = zone.getMinPos();
                BlockPos max = zone.getMaxPos();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Informations sur la zone '" + name + "':"));
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Dimension: " + dimension));
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Coordonn\u00e9es: [" + min.func_177958_n() + ", " + min.func_177956_o() + ", " + min.func_177952_p() + "] \u00e0 [" + max.func_177958_n() + ", " + max.func_177956_o() + ", " + max.func_177952_p() + "]"));
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Temp\u00e9rature: " + String.format("%.1f\u00b0C", zone.getTemperature())));
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Rayon de fusion: " + zone.getBlendRadius() + " blocs"));
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Priorit\u00e9: " + zone.getPriority()));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Aucune zone de temp\u00e9rature nomm\u00e9e '" + name + "' trouv\u00e9e dans la dimension " + dimension));
        }
    }

    private void handleClear(ICommandSender sender) {
        TemperatureZones.clearAllZones();
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Toutes les zones de temp\u00e9rature ont \u00e9t\u00e9 supprim\u00e9es"));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return TemperatureZoneCommand.func_71530_a((String[])args, (String[])new String[]{"create", "remove", "list", "info", "clear"});
        }
        if (args.length == 2 && ("remove".equals(args[0]) || "info".equals(args[0]))) {
            int dimension = sender.func_130014_f_().field_73011_w.getDimension();
            ArrayList<String> zoneNames = new ArrayList<String>();
            for (TemperatureZones.TemperatureZone zone : TemperatureZones.getZonesForDimension(dimension)) {
                zoneNames.add(zone.getName());
            }
            return TemperatureZoneCommand.func_175762_a((String[])args, zoneNames);
        }
        return Collections.emptyList();
    }
}

