/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.temperature.DefaultTemperature;
import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.RaceTemperatureModifiers;
import fr.minepiece.common.capability.temperature.TemperatureProvider;
import fr.minepiece.common.utils.BiomeTemperatures;
import fr.minepiece.common.utils.TemperatureZones;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;

public class TemperatureDebugCommand
extends CommandBase {
    public String func_71517_b() {
        return "Minepiece_temp_debug";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_temp_debug [race|biome|player|settings|zones]";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.displayGeneralInfo(sender);
        } else {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "race": {
                    this.displayRaceTemperatures(sender);
                    break;
                }
                case "biome": {
                    this.displayBiomeTemperatures(sender);
                    break;
                }
                case "player": {
                    if (sender instanceof EntityPlayer) {
                        this.displayPlayerTemperature(sender, (EntityPlayer)sender);
                        break;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Cette commande doit \u00eatre ex\u00e9cut\u00e9e par un joueur"));
                    break;
                }
                case "settings": {
                    this.displaySettings(sender);
                    break;
                }
                case "zones": {
                    if (sender instanceof EntityPlayer) {
                        this.displayZonesInfo(sender, (EntityPlayer)sender);
                        break;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Cette commande doit \u00eatre ex\u00e9cut\u00e9e par un joueur"));
                    break;
                }
                default: {
                    throw new CommandException("Sous-commande inconnue : " + subCommand, new Object[0]);
                }
            }
        }
    }

    private void displayGeneralInfo(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Informations de temp\u00e9rature ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Intervalle de mise \u00e0 jour : " + DefaultTemperature.getUpdateInterval() + " ticks (" + (double)DefaultTemperature.getUpdateInterval() / 20.0 + " secondes)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Taux de changement : " + DefaultTemperature.getDefaultTempChange() + " par intervalle"));
    }

    private void displayRaceTemperatures(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Temp\u00e9ratures corporelles des races ==="));
        for (MinePieceRaces race : MinePieceRaces.values()) {
            double temp = RaceTemperatureModifiers.getRaceBaseTemperature(race);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + race.name() + " : " + String.format("%.1f\u00b0C", temp)));
        }
    }

    private void displayBiomeTemperatures(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Temp\u00e9ratures des biomes ==="));
        Map<String, Double> biomeTemps = BiomeTemperatures.getAllBiomeTemperatures();
        for (Map.Entry<String, Double> entry : biomeTemps.entrySet()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + entry.getKey() + " : " + String.format("%.1f\u00b0C", entry.getValue())));
        }
    }

    private void displayPlayerTemperature(ICommandSender sender, EntityPlayer player) {
        ITemperature temp = (ITemperature)player.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null);
        if (temp != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Temp\u00e9rature du joueur ==="));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Temp\u00e9rature actuelle : " + String.format("%.1f\u00b0C", temp.getTemperature())));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Temp\u00e9rature de base : " + String.format("%.1f\u00b0C", temp.getBaseTemperature())));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "\u00c9tat : " + temp.getCurrentState().name()));
            Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
            double envTemp = BiomeTemperatures.getFinalEnvironmentTemperature(player.field_70170_p, player.func_180425_c(), player.field_70170_p.func_72820_D());
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Biome actuel : " + biome.getRegistryName()));
            TemperatureZones.TemperatureZone zone = TemperatureZones.getZoneAt(player.field_70170_p, player.func_180425_c());
            if (zone != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Zone de temp\u00e9rature : " + zone.getName() + " (" + String.format("%.1f\u00b0C", zone.getTemperature()) + ")"));
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Temp\u00e9rature environnementale : " + String.format("%.1f\u00b0C", envTemp)));
        }
    }

    private void displaySettings(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Param\u00e8tres du syst\u00e8me de temp\u00e9rature ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Intervalle de mise \u00e0 jour : " + DefaultTemperature.getUpdateInterval() + " ticks"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Taux de changement par d\u00e9faut : " + DefaultTemperature.getDefaultTempChange()));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Seuil de froid : 10.0\u00b0C"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Seuil de chaleur : 30.0\u00b0C"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Temp\u00e9rature minimale : -10.0\u00b0C"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Temp\u00e9rature maximale : 45.0\u00b0C"));
    }

    private void displayZonesInfo(ICommandSender sender, EntityPlayer player) {
        int dimension = player.field_70170_p.field_73011_w.getDimension();
        List<TemperatureZones.TemperatureZone> zones = TemperatureZones.getZonesForDimension(dimension);
        if (zones.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Aucune zone de temp\u00e9rature d\u00e9finie dans cette dimension"));
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Zones de temp\u00e9rature ==="));
        for (TemperatureZones.TemperatureZone zone : zones) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Zone: " + zone.getName()));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "  Position: [" + zone.getMinPos().func_177958_n() + ", " + zone.getMinPos().func_177956_o() + ", " + zone.getMinPos().func_177952_p() + "] \u00e0 [" + zone.getMaxPos().func_177958_n() + ", " + zone.getMaxPos().func_177956_o() + ", " + zone.getMaxPos().func_177952_p() + "]"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "  Temp\u00e9rature: " + String.format("%.1f\u00b0C", zone.getTemperature())));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "  Rayon de fusion: " + zone.getBlendRadius() + " blocs"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "  Priorit\u00e9: " + zone.getPriority()));
            if (!zone.contains(player.func_180425_c())) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "  * Vous \u00eates actuellement dans cette zone *"));
        }
        List<Map.Entry<TemperatureZones.TemperatureZone, Double>> influencingZones = TemperatureZones.getInfluencingZones(player.field_70170_p, player.func_180425_c());
        if (!influencingZones.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Zones influen\u00e7ant votre position actuelle:"));
            for (Map.Entry<TemperatureZones.TemperatureZone, Double> entry : influencingZones) {
                TemperatureZones.TemperatureZone zone = entry.getKey();
                double influence = entry.getValue();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + zone.getName() + ": influence " + String.format("%.1f%%", influence * 100.0)));
            }
        }
    }
}

