/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.temperature.DefaultTemperature;
import fr.minepiece.common.capability.temperature.RaceTemperatureModifiers;
import fr.minepiece.common.utils.BiomeTemperatures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TemperatureConfigCommand
extends CommandBase {
    private static final Map<String, String> RACE_ALIASES = new HashMap<String, String>();
    private static final Map<String, String> BIOME_ALIASES = new HashMap<String, String>();

    public String func_71517_b() {
        return "Minepiece_temp_modifier";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_temp_modifier <body|biome|ticks|decrease> <param> [value]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subCommand;
        if (args.length < 2) {
            throw new CommandException("Utilisation : " + this.func_71518_a(sender), new Object[0]);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "body": {
                if (args.length < 3) {
                    throw new CommandException("Utilisation : /Minepiece_temp_modifier body <race> <temp\u00e9rature>", new Object[0]);
                }
                this.handleBodyTemperature(sender, args[1], this.parseTemperature(args[2]));
                break;
            }
            case "biome": {
                if (args.length < 3) {
                    throw new CommandException("Utilisation : /Minepiece_temp_modifier biome <nom_biome> <temp\u00e9rature>", new Object[0]);
                }
                this.handleBiomeTemperature(sender, args[1], this.parseTemperature(args[2]));
                break;
            }
            case "ticks": {
                this.handleUpdateInterval(sender, TemperatureConfigCommand.func_175755_a((String)args[1]));
                break;
            }
            case "decrease": {
                this.handleTemperatureChange(sender, this.parseTemperature(args[1]));
                break;
            }
            default: {
                throw new CommandException("Sous-commande inconnue : " + subCommand, new Object[0]);
            }
        }
    }

    private void handleBodyTemperature(ICommandSender sender, String raceInput, double temperature) throws CommandException {
        try {
            MinePieceRaces race = this.getRaceFromString(raceInput);
            RaceTemperatureModifiers.setRaceBaseTemperature(race, temperature);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Temp\u00e9rature corporelle de base pour " + race.name() + " r\u00e9gl\u00e9e \u00e0 " + temperature + "\u00b0C"));
        }
        catch (IllegalArgumentException e) {
            throw new CommandException("Race inconnue : " + raceInput, new Object[0]);
        }
    }

    private void handleBiomeTemperature(ICommandSender sender, String biomeInput, double temperature) {
        String biomeName = BIOME_ALIASES.getOrDefault(biomeInput.toLowerCase(), biomeInput);
        BiomeTemperatures.registerBiomeTemperature(biomeName, temperature);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Temp\u00e9rature du biome " + biomeName + " r\u00e9gl\u00e9e \u00e0 " + temperature + "\u00b0C"));
    }

    private void handleUpdateInterval(ICommandSender sender, int ticks) throws CommandException {
        if (ticks < 20) {
            throw new CommandException("L'intervalle de mise \u00e0 jour doit \u00eatre d'au moins 20 ticks (1 seconde)", new Object[0]);
        }
        DefaultTemperature.setUpdateInterval(ticks);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Intervalle de mise \u00e0 jour de la temp\u00e9rature r\u00e9gl\u00e9 \u00e0 " + ticks + " ticks (" + (double)ticks / 20.0 + " secondes)"));
    }

    private void handleTemperatureChange(ICommandSender sender, double change) throws CommandException {
        if (change <= 0.0) {
            throw new CommandException("Le taux de changement doit \u00eatre positif", new Object[0]);
        }
        DefaultTemperature.setDefaultTempChange(change);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Taux de changement de temp\u00e9rature r\u00e9gl\u00e9 \u00e0 " + change + " par intervalle"));
    }

    private double parseTemperature(String value) throws CommandException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new CommandException("Valeur de temp\u00e9rature invalide : " + value, new Object[0]);
        }
    }

    private MinePieceRaces getRaceFromString(String raceInput) throws IllegalArgumentException {
        String raceName = RACE_ALIASES.getOrDefault(raceInput.toLowerCase(), raceInput.toUpperCase());
        return MinePieceRaces.valueOf(raceName);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("body");
            completions.add("biome");
            completions.add("ticks");
            completions.add("decrease");
        } else if (args.length == 2) {
            if ("body".equalsIgnoreCase(args[0])) {
                completions.addAll(RACE_ALIASES.keySet());
            } else if ("biome".equalsIgnoreCase(args[0])) {
                completions.addAll(BIOME_ALIASES.keySet());
            }
        }
        return TemperatureConfigCommand.func_175762_a((String[])args, completions);
    }

    static {
        RACE_ALIASES.put("human", "HUMAN");
        RACE_ALIASES.put("giant", "GIANT");
        RACE_ALIASES.put("minks", "MINKS");
        RACE_ALIASES.put("fishman", "FISHMAN");
        RACE_ALIASES.put("cyborg", "CYBORG");
        BIOME_ALIASES.put("desert", "minecraft:desert");
        BIOME_ALIASES.put("plains", "minecraft:plains");
        BIOME_ALIASES.put("forest", "minecraft:forest");
        BIOME_ALIASES.put("ocean", "minecraft:ocean");
        BIOME_ALIASES.put("swamp", "minecraft:swampland");
        BIOME_ALIASES.put("taiga", "minecraft:taiga");
        BIOME_ALIASES.put("jungle", "minecraft:jungle");
        BIOME_ALIASES.put("savanna", "minecraft:savanna");
        BIOME_ALIASES.put("mesa", "minecraft:mesa");
        BIOME_ALIASES.put("ice_plains", "minecraft:ice_flats");
    }
}

