/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.utils.ClusterConfigManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ClusterDebugCommand
extends CommandBase {
    public String func_71517_b() {
        return "Minepiece_cluster_info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_cluster_info [regrowth|drop|all]";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 || "all".equalsIgnoreCase(args[0])) {
            this.displayAllInfo(sender);
        } else {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "regrowth": {
                    this.displayRegrowthInfo(sender);
                    break;
                }
                case "drop": {
                    this.displayDropInfo(sender);
                    break;
                }
                default: {
                    throw new CommandException("Sous-commande inconnue : " + subCommand + ". Utilisez 'regrowth', 'drop' ou 'all'.", new Object[0]);
                }
            }
        }
    }

    private void displayAllInfo(ICommandSender sender) {
        this.displayHeader(sender);
        this.displayRegrowthInfo(sender);
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        this.displayDropInfo(sender);
    }

    private void displayHeader(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Configuration des clusters ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Mode actuel : " + (ClusterConfigManager.isTestMode() ? TextFormatting.GREEN + "TEST" : TextFormatting.RED + "PRODUCTION")));
    }

    private void displayRegrowthInfo(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Temps de repousse des clusters ==="));
        String modeText = ClusterConfigManager.isTestMode() ? "TEST" : "PRODUCTION";
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Mode " + modeText + " (actif):"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "\u00c9puis\u00e9 -> Petit : " + ClusterConfigManager.getDepletedRegrowthTime() + " ticks (" + this.formatTime(ClusterConfigManager.getDepletedRegrowthTime()) + ")"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Petit -> Moyen : " + ClusterConfigManager.getSmallRegrowthTime() + " ticks (" + this.formatTime(ClusterConfigManager.getSmallRegrowthTime()) + ")"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Moyen -> Grand : " + ClusterConfigManager.getMediumRegrowthTime() + " ticks (" + this.formatTime(ClusterConfigManager.getMediumRegrowthTime()) + ")"));
        if (ClusterConfigManager.isTestMode()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "\nMode PRODUCTION (inactif):"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "\u00c9puis\u00e9 -> Petit : " + ClusterConfigManager.getDepletedRegrowthTimeProd() + " ticks (" + this.formatTime(ClusterConfigManager.getDepletedRegrowthTimeProd()) + ")"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "Petit -> Moyen : " + ClusterConfigManager.getSmallRegrowthTimeProd() + " ticks (" + this.formatTime(ClusterConfigManager.getSmallRegrowthTimeProd()) + ")"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "Moyen -> Grand : " + ClusterConfigManager.getMediumRegrowthTimeProd() + " ticks (" + this.formatTime(ClusterConfigManager.getMediumRegrowthTimeProd()) + ")"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "\nMode TEST (inactif):"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "\u00c9puis\u00e9 -> Petit : " + ClusterConfigManager.getDepletedRegrowthTimeTest() + " ticks (" + this.formatTime(ClusterConfigManager.getDepletedRegrowthTimeTest()) + ")"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "Petit -> Moyen : " + ClusterConfigManager.getSmallRegrowthTimeTest() + " ticks (" + this.formatTime(ClusterConfigManager.getSmallRegrowthTimeTest()) + ")"));
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "Moyen -> Grand : " + ClusterConfigManager.getMediumRegrowthTimeTest() + " ticks (" + this.formatTime(ClusterConfigManager.getMediumRegrowthTimeTest()) + ")"));
        }
    }

    private void displayDropInfo(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Quantit\u00e9s de drop des clusters ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Petit cluster : " + ClusterConfigManager.getSmallDropCount() + " item(s)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Cluster moyen : " + ClusterConfigManager.getMediumMinDropCount() + " \u00e0 " + ClusterConfigManager.getMediumMaxDropCount() + " item(s)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Grand cluster : " + ClusterConfigManager.getBigMinDropCount() + " \u00e0 " + ClusterConfigManager.getBigMaxDropCount() + " item(s)"));
    }

    private String formatTime(int ticks) {
        double seconds = (double)ticks / 20.0;
        if (seconds < 60.0) {
            return String.format("%.1f secondes", seconds);
        }
        if (seconds < 3600.0) {
            int minutes = (int)(seconds / 60.0);
            int remainingSeconds = (int)(seconds % 60.0);
            return String.format("%d min %d sec", minutes, remainingSeconds);
        }
        int hours = (int)(seconds / 3600.0);
        int minutes = (int)(seconds % 3600.0 / 60.0);
        return String.format("%d h %d min", hours, minutes);
    }
}

