/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.server.commands;

import fr.minepiece.common.utils.ClusterConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ClusterConfigCommand
extends CommandBase {
    private static final Map<String, String> ALIASES = new HashMap<String, String>();

    public String func_71517_b() {
        return "Minepiece_cluster_config";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/Minepiece_cluster_config <regrowth|drop|mode|save|load> <param> [value]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subCommand;
        if (args.length < 1) {
            throw new CommandException("Utilisation : " + this.func_71518_a(sender), new Object[0]);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "regrowth": {
                if (args.length < 2) {
                    this.displayAllRegrowthTimes(sender);
                    break;
                }
                if (args.length < 3) {
                    throw new CommandException("Utilisation : /Minepiece_cluster_config regrowth <depleted|small|medium> <ticks>", new Object[0]);
                }
                this.handleRegrowthConfig(sender, args[1], ClusterConfigCommand.func_175755_a((String)args[2]));
                break;
            }
            case "drop": {
                if (args.length < 2) {
                    this.displayAllDropCounts(sender);
                    break;
                }
                if (args.length < 3) {
                    this.displayDropConfigForType(sender, args[1]);
                    break;
                }
                this.handleDropConfig(sender, args[1], args.length > 3 ? args[2] : "count", args.length > 3 ? args[3] : args[2]);
                break;
            }
            case "mode": {
                this.toggleMode(sender);
                break;
            }
            case "save": {
                ClusterConfigManager.saveConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Configuration des clusters sauvegard\u00e9e dans le fichier de configuration"));
                break;
            }
            case "load": {
                ClusterConfigManager.loadConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Configuration des clusters charg\u00e9e depuis le fichier de configuration"));
                break;
            }
            default: {
                throw new CommandException("Sous-commande inconnue : " + subCommand, new Object[0]);
            }
        }
    }

    private void displayAllRegrowthTimes(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Temps de repousse des clusters ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "\u00c9puis\u00e9 -> Petit : " + ClusterConfigManager.getDepletedRegrowthTime() + " ticks (" + (double)ClusterConfigManager.getDepletedRegrowthTime() / 20.0 + " secondes)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Petit -> Moyen : " + ClusterConfigManager.getSmallRegrowthTime() + " ticks (" + (double)ClusterConfigManager.getSmallRegrowthTime() / 20.0 + " secondes)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Moyen -> Grand : " + ClusterConfigManager.getMediumRegrowthTime() + " ticks (" + (double)ClusterConfigManager.getMediumRegrowthTime() / 20.0 + " secondes)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Mode actuel : " + (ClusterConfigManager.isTestMode() ? "TEST" : "PRODUCTION")));
    }

    private void displayAllDropCounts(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Quantit\u00e9s de drop des clusters ==="));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Petit cluster : " + ClusterConfigManager.getSmallDropCount() + " item(s)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Cluster moyen : " + ClusterConfigManager.getMediumMinDropCount() + " \u00e0 " + ClusterConfigManager.getMediumMaxDropCount() + " item(s)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Grand cluster : " + ClusterConfigManager.getBigMinDropCount() + " \u00e0 " + ClusterConfigManager.getBigMaxDropCount() + " item(s)"));
    }

    private void displayDropConfigForType(ICommandSender sender, String typeInput) throws CommandException {
        String type = this.getClusterTypeFromAlias(typeInput);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "=== Configuration de drop pour " + type + " ==="));
        switch (type) {
            case "small": {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Petit cluster : " + ClusterConfigManager.getSmallDropCount() + " item(s)"));
                break;
            }
            case "medium": {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Cluster moyen : min=" + ClusterConfigManager.getMediumMinDropCount() + ", max=" + ClusterConfigManager.getMediumMaxDropCount() + " item(s)"));
                break;
            }
            case "big": {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Grand cluster : min=" + ClusterConfigManager.getBigMinDropCount() + ", max=" + ClusterConfigManager.getBigMaxDropCount() + " item(s)"));
                break;
            }
            default: {
                throw new CommandException("Type de cluster inconnu : " + typeInput, new Object[0]);
            }
        }
    }

    private void handleRegrowthConfig(ICommandSender sender, String typeInput, int time) throws CommandException {
        String type;
        if (time < 1) {
            throw new CommandException("Le temps doit \u00eatre d'au moins 1 tick", new Object[0]);
        }
        switch (type = this.getClusterTypeFromAlias(typeInput)) {
            case "depleted": {
                ClusterConfigManager.setDepletedRegrowthTime(time);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Temps de repousse pour les clusters \u00e9puis\u00e9s r\u00e9gl\u00e9 \u00e0 " + time + " ticks (" + (double)time / 20.0 + " secondes)"));
                break;
            }
            case "small": {
                ClusterConfigManager.setSmallRegrowthTime(time);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Temps de repousse pour les petits clusters r\u00e9gl\u00e9 \u00e0 " + time + " ticks (" + (double)time / 20.0 + " secondes)"));
                break;
            }
            case "medium": {
                ClusterConfigManager.setMediumRegrowthTime(time);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Temps de repousse pour les clusters moyens r\u00e9gl\u00e9 \u00e0 " + time + " ticks (" + (double)time / 20.0 + " secondes)"));
                break;
            }
            default: {
                throw new CommandException("Type de cluster inconnu : " + typeInput, new Object[0]);
            }
        }
    }

    private void handleDropConfig(ICommandSender sender, String typeInput, String param, String valueStr) throws CommandException {
        String type;
        int value = ClusterConfigCommand.func_175755_a((String)valueStr);
        if (value < 0) {
            throw new CommandException("La valeur doit \u00eatre positive", new Object[0]);
        }
        switch (type = this.getClusterTypeFromAlias(typeInput)) {
            case "small": {
                ClusterConfigManager.setSmallDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 de drop pour les petits clusters r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            case "medium": {
                this.handleMediumDropConfig(sender, param, value);
                break;
            }
            case "big": {
                this.handleBigDropConfig(sender, param, value);
                break;
            }
            default: {
                throw new CommandException("Type de cluster inconnu : " + typeInput, new Object[0]);
            }
        }
    }

    private void handleMediumDropConfig(ICommandSender sender, String param, int value) throws CommandException {
        switch (param.toLowerCase()) {
            case "min": {
                if (value > ClusterConfigManager.getMediumMaxDropCount()) {
                    throw new CommandException("La valeur min ne peut pas \u00eatre sup\u00e9rieure \u00e0 la valeur max (" + ClusterConfigManager.getMediumMaxDropCount() + ")", new Object[0]);
                }
                ClusterConfigManager.setMediumMinDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 minimale de drop pour les clusters moyens r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            case "max": {
                if (value < ClusterConfigManager.getMediumMinDropCount()) {
                    throw new CommandException("La valeur max ne peut pas \u00eatre inf\u00e9rieure \u00e0 la valeur min (" + ClusterConfigManager.getMediumMinDropCount() + ")", new Object[0]);
                }
                ClusterConfigManager.setMediumMaxDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 maximale de drop pour les clusters moyens r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            case "count": {
                ClusterConfigManager.setMediumMinDropCount(value);
                ClusterConfigManager.setMediumMaxDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 fixe de drop pour les clusters moyens r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            default: {
                throw new CommandException("Param\u00e8tre inconnu pour les clusters moyens : " + param + ". Utilisez 'min', 'max' ou sp\u00e9cifiez une valeur fixe.", new Object[0]);
            }
        }
    }

    private void handleBigDropConfig(ICommandSender sender, String param, int value) throws CommandException {
        switch (param.toLowerCase()) {
            case "min": {
                if (value > ClusterConfigManager.getBigMaxDropCount()) {
                    throw new CommandException("La valeur min ne peut pas \u00eatre sup\u00e9rieure \u00e0 la valeur max (" + ClusterConfigManager.getBigMaxDropCount() + ")", new Object[0]);
                }
                ClusterConfigManager.setBigMinDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 minimale de drop pour les grands clusters r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            case "max": {
                if (value < ClusterConfigManager.getBigMinDropCount()) {
                    throw new CommandException("La valeur max ne peut pas \u00eatre inf\u00e9rieure \u00e0 la valeur min (" + ClusterConfigManager.getBigMinDropCount() + ")", new Object[0]);
                }
                ClusterConfigManager.setBigMaxDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 maximale de drop pour les grands clusters r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            case "count": {
                ClusterConfigManager.setBigMinDropCount(value);
                ClusterConfigManager.setBigMaxDropCount(value);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Quantit\u00e9 fixe de drop pour les grands clusters r\u00e9gl\u00e9e \u00e0 " + value + " item(s)"));
                break;
            }
            default: {
                throw new CommandException("Param\u00e8tre inconnu pour les grands clusters : " + param + ". Utilisez 'min', 'max' ou sp\u00e9cifiez une valeur fixe.", new Object[0]);
            }
        }
    }

    private void toggleMode(ICommandSender sender) {
        boolean newMode = ClusterConfigManager.toggleTestMode();
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Mode bascul\u00e9 vers : " + (newMode ? "TEST" : "PRODUCTION")));
    }

    private String getClusterTypeFromAlias(String input) throws CommandException {
        String type = ALIASES.get(input.toLowerCase());
        if (type == null) {
            throw new CommandException("Type de cluster inconnu : " + input + ". Utilisez 'depleted', 'small', 'medium' ou 'big'.", new Object[0]);
        }
        return type;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        String type;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("regrowth");
            completions.add("drop");
            completions.add("mode");
            completions.add("save");
            completions.add("load");
        } else if (args.length == 2) {
            if ("regrowth".equalsIgnoreCase(args[0]) || "drop".equalsIgnoreCase(args[0])) {
                completions.add("depleted");
                completions.add("small");
                completions.add("medium");
                completions.add("big");
            }
        } else if (args.length == 3 && "drop".equalsIgnoreCase(args[0]) && ("medium".equals(type = ALIASES.getOrDefault(args[1].toLowerCase(), "")) || "big".equals(type))) {
            completions.add("min");
            completions.add("max");
        }
        return ClusterConfigCommand.func_175762_a((String[])args, completions);
    }

    static {
        ALIASES.put("depleted", "depleted");
        ALIASES.put("epuise", "depleted");
        ALIASES.put("small", "small");
        ALIASES.put("petit", "small");
        ALIASES.put("medium", "medium");
        ALIASES.put("moyen", "medium");
        ALIASES.put("big", "big");
        ALIASES.put("grand", "big");
    }
}

