/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils.shockwave;

import fr.minepiece.common.utils.shockwave.RippleEvents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Ripple {
    private final World world;
    private final BlockPos centerLoc;
    private double radiusStart;
    private double radius;
    private final double interval;
    private double height;
    private List<IBlockState> blocks;
    private CopyOnWriteArrayList<BlockPos> summonedLocations;
    private final Object lock = new Object();
    private int delayTicks = 0;
    private boolean continueRipple = false;

    public Ripple(World world, BlockPos centerLoc, double radiusStart, double radius, double interval, double height) {
        this.world = world;
        this.centerLoc = centerLoc;
        this.radiusStart = radiusStart;
        this.radius = radius;
        this.interval = interval;
        this.height = height;
        this.summonedLocations = new CopyOnWriteArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        double x = this.centerLoc.func_177958_n();
        double y = this.centerLoc.func_177956_o();
        double z = this.centerLoc.func_177952_p();
        int iii = 0;
        ArrayList<BlockPos> newLocs = new ArrayList<BlockPos>();
        ArrayList<EntityFallingBlock> fallingBlocksToSpawn = new ArrayList<EntityFallingBlock>();
        for (double theta = 0.0; theta <= Math.PI * 2; theta += this.interval) {
            double dx = this.radiusStart * Math.cos(theta);
            double dz = this.radiusStart * Math.sin(theta);
            int i = 0;
            while ((double)i < this.height) {
                BlockPos newLoc = new BlockPos(x + dx, y + (double)i, z + dz);
                if (!this.summonedLocations.contains(newLoc)) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.world, (double)newLoc.func_177958_n(), (double)newLoc.func_177956_o(), (double)newLoc.func_177952_p(), this.world.func_180495_p(newLoc));
                    NBTTagCompound entityData = new NBTTagCompound();
                    entityData.func_74783_a("OrigPos", new int[]{newLoc.func_177958_n(), newLoc.func_177956_o(), newLoc.func_177952_p()});
                    fallingBlock.getEntityData().func_179237_a(entityData);
                    fallingBlock.func_96094_a("minepiece-shockwave");
                    fallingBlock.func_70107_b((double)newLoc.func_177958_n(), (double)newLoc.func_177956_o(), (double)newLoc.func_177952_p());
                    fallingBlock.field_145813_c = false;
                    fallingBlock.field_145812_b = -500;
                    Vec3d centerVec = new Vec3d(x, y, z);
                    Vec3d blockPosVec = new Vec3d((double)newLoc.func_177958_n(), (double)newLoc.func_177956_o(), (double)newLoc.func_177952_p());
                    Vec3d velocity = centerVec.func_178788_d(blockPosVec).func_72432_b().func_186678_a(0.2);
                    fallingBlock.field_70159_w = -velocity.field_72450_a;
                    fallingBlock.field_70181_x = 0.5;
                    fallingBlock.field_70179_y = -velocity.field_72449_c;
                    fallingBlocksToSpawn.add(fallingBlock);
                    newLocs.add(newLoc);
                }
                ++i;
            }
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.summonedLocations.addAll(newLocs);
        }
        for (EntityFallingBlock fallingBlock : fallingBlocksToSpawn) {
            this.world.func_72838_d((Entity)fallingBlock);
            ++iii;
        }
        this.radiusStart += this.interval;
        if (this.radiusStart >= this.radius) {
            System.out.println("stop");
            RippleEvents.continueRipple = false;
            RippleEvents.setRipple(null);
        } else {
            System.out.println("ContinueRippleWithDelay");
            RippleEvents.continueRippleWithDelay(3);
        }
        System.out.println("FINAL : " + iii);
    }

    public void continueRippleWithDelay(long delay) {
        RippleEvents.delayTicks = (int)delay;
        RippleEvents.continueRipple = true;
    }
}

