/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils.helpers;

import fr.minepiece.common.network.packets.races.CyborgWavePacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class AABBHelper {
    public static List<AxisAlignedBB> getSegmentBoundingBoxes(Vec3d start, Vec3d end, double length, double beamRadius, int numSegments) {
        ArrayList<AxisAlignedBB> segmentBoundingBoxes = new ArrayList<AxisAlignedBB>();
        Vec3d direction = end.func_178788_d(start).func_72432_b();
        Vec3d right = new Vec3d(-direction.field_72449_c, 0.0, direction.field_72450_a).func_72432_b().func_186678_a(beamRadius);
        Vec3d up = direction.func_72431_c(right).func_72432_b().func_186678_a(beamRadius);
        double segmentLength = length / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            Vec3d segmentStart = start.func_178787_e(direction.func_186678_a(segmentLength * (double)i));
            Vec3d segmentEnd = start.func_178787_e(direction.func_186678_a(segmentLength * (double)(i + 1)));
            Vec3d minPoint = segmentStart.func_178788_d(right).func_178788_d(up);
            Vec3d maxPoint = segmentEnd.func_178787_e(right).func_178787_e(up);
            segmentBoundingBoxes.add(new AxisAlignedBB(minPoint.field_72450_a, minPoint.field_72448_b, minPoint.field_72449_c, maxPoint.field_72450_a, maxPoint.field_72448_b, maxPoint.field_72449_c));
        }
        return segmentBoundingBoxes;
    }

    public static boolean doesEntityIntersectWithBoundingBoxes(Entity entity, Iterable<AxisAlignedBB> boundingBoxes) {
        AxisAlignedBB entityBoundingBox = entity.func_174813_aQ();
        for (AxisAlignedBB boundingBox : boundingBoxes) {
            if (!entityBoundingBox.func_72326_a(boundingBox)) continue;
            return true;
        }
        return false;
    }

    public static AxisAlignedBB createBoundingBox(Vec3d pos1, Vec3d pos2) {
        double x1 = Math.min(pos1.field_72450_a, pos2.field_72450_a);
        double y1 = Math.min(pos1.field_72448_b, pos2.field_72448_b);
        double z1 = Math.min(pos1.field_72449_c, pos2.field_72449_c);
        double x2 = Math.max(pos1.field_72450_a, pos2.field_72450_a);
        double y2 = Math.max(pos1.field_72448_b, pos2.field_72448_b);
        double z2 = Math.max(pos1.field_72449_c, pos2.field_72449_c);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public static List<AxisAlignedBB> createBoundingBoxes(List<Vec3d> points) {
        ArrayList<AxisAlignedBB> boundingBoxes = new ArrayList<AxisAlignedBB>();
        int size = points.size();
        for (int i = 0; i < size; i += 2) {
            Vec3d point1 = points.get(i);
            Vec3d point2 = i + 1 < size ? points.get(i + 1) : points.get(i - 1);
            AxisAlignedBB boundingBox = AABBHelper.createBoundingBox(point1, point2);
            boundingBox = boundingBox.func_186662_g(0.5);
            boundingBoxes.add(boundingBox);
        }
        return boundingBoxes;
    }

    public static List<AxisAlignedBB> generateSphereBoundingBoxes(Vec3d center, double radius, int numSegments) {
        ArrayList<AxisAlignedBB> boundingBoxes = new ArrayList<AxisAlignedBB>();
        for (int i = 0; i < numSegments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numSegments;
            double x = center.field_72450_a + radius * Math.cos(angle);
            double z = center.field_72449_c + radius * Math.sin(angle);
            Vec3d point1 = new Vec3d(x, center.field_72448_b - radius, z);
            Vec3d point2 = new Vec3d(x, center.field_72448_b + radius, z);
            AxisAlignedBB boundingBox = AABBHelper.createBoundingBox(point1, point2);
            boundingBox = boundingBox.func_186662_g(0.5);
            boundingBoxes.add(boundingBox);
        }
        return boundingBoxes;
    }

    public static List<AxisAlignedBB> generateSphereBoundingBoxes(CyborgWavePacket packet, double radius, int numSegments) {
        return AABBHelper.generateSphereBoundingBoxes(packet.getCenter(), radius, numSegments);
    }
}

