/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.minepiece.MinePiece;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class XPConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    private static int secondsBetweenPassiveXP;
    private static int passiveXPAmount;
    private static boolean giveJobXP;

    public static void initialize(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "minepiece");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((configFile = new File(configDir, "xp_config.json")).exists()) {
            XPConfigManager.loadConfig();
        } else {
            XPConfigManager.saveDefaultConfig();
        }
        MinePiece.LOGGER.info("Configuration XP initialis\u00e9e avec succ\u00e8s");
    }

    public static void saveConfig() {
        try {
            JsonObject root = new JsonObject();
            root.addProperty("seconds_between_passive_xp", (Number)secondsBetweenPassiveXP);
            root.addProperty("passive_xp_amount", (Number)passiveXPAmount);
            root.addProperty("give_job_xp", Boolean.valueOf(giveJobXP));
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            MinePiece.LOGGER.info("Configuration XP sauvegard\u00e9e avec succ\u00e8s");
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors de la sauvegarde de la configuration XP", (Throwable)e);
        }
    }

    public static void loadConfig() {
        try {
            JsonObject root;
            if (!configFile.exists()) {
                XPConfigManager.saveDefaultConfig();
                return;
            }
            try (FileReader reader = new FileReader(configFile);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            if (root.has("seconds_between_passive_xp")) {
                secondsBetweenPassiveXP = root.get("seconds_between_passive_xp").getAsInt();
            }
            if (root.has("passive_xp_amount")) {
                passiveXPAmount = root.get("passive_xp_amount").getAsInt();
            }
            if (root.has("give_job_xp")) {
                giveJobXP = root.get("give_job_xp").getAsBoolean();
            }
            MinePiece.LOGGER.info("Configuration XP charg\u00e9e avec succ\u00e8s");
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors du chargement de la configuration XP", (Throwable)e);
        }
    }

    private static void saveDefaultConfig() {
        XPConfigManager.saveConfig();
    }

    public static int getSecondsBetweenPassiveXP() {
        return secondsBetweenPassiveXP;
    }

    public static void setSecondsBetweenPassiveXP(int seconds) {
        if (seconds < 1) {
            seconds = 1;
        }
        secondsBetweenPassiveXP = seconds;
    }

    public static int getPassiveXPAmount() {
        return passiveXPAmount;
    }

    public static void setPassiveXPAmount(int amount) {
        if (amount < 0) {
            amount = 0;
        }
        passiveXPAmount = amount;
    }

    public static boolean isGiveJobXP() {
        return giveJobXP;
    }

    public static void setGiveJobXP(boolean give) {
        giveJobXP = give;
    }

    public static boolean toggleGiveJobXP() {
        giveJobXP = !giveJobXP;
        return giveJobXP;
    }

    static {
        secondsBetweenPassiveXP = 60;
        passiveXPAmount = 6;
        giveJobXP = false;
    }
}

