/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WeaponZoomHandler {
    private static final WeaponZoomHandler INSTANCE = new WeaponZoomHandler();
    private boolean isZooming = false;
    private float zoomLevel = 3.0f;
    private Float defaultMouseSensitivity;
    private int scrollTimer = 0;

    private WeaponZoomHandler() {
    }

    public static WeaponZoomHandler getInstance() {
        return INSTANCE;
    }

    public void setZooming(boolean zooming) {
        if (this.isZooming != zooming) {
            this.isZooming = zooming;
            if (!zooming) {
                GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
                if (this.defaultMouseSensitivity != null) {
                    gameSettings.field_74341_c = this.defaultMouseSensitivity.floatValue();
                    this.defaultMouseSensitivity = null;
                }
            }
        }
    }

    public boolean isZooming() {
        return this.isZooming;
    }

    public float getModifiedFov(float originalFov) {
        if (!this.isZooming) {
            return originalFov;
        }
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (this.defaultMouseSensitivity == null) {
            this.defaultMouseSensitivity = Float.valueOf(gameSettings.field_74341_c);
        }
        gameSettings.field_74341_c = this.defaultMouseSensitivity.floatValue() * (originalFov / this.zoomLevel / originalFov);
        return originalFov / this.zoomLevel;
    }

    public void handleScroll(int scrollAmount) {
        if (this.scrollTimer > 0) {
            --this.scrollTimer;
            return;
        }
        if (!this.isZooming) {
            return;
        }
        if (scrollAmount > 0) {
            this.zoomLevel *= 1.1f;
        } else if (scrollAmount < 0) {
            this.zoomLevel *= 0.9f;
        }
        this.zoomLevel = MathHelper.func_76131_a((float)this.zoomLevel, (float)1.0f, (float)10.0f);
        this.scrollTimer = 2;
    }

    public void setZoomLevelForTier(int tier) {
        this.zoomLevel = 3.0f + (float)tier * 0.5f;
    }
}

