/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.VisualizeZonePacket;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemperatureZones {
    private static final Logger LOGGER = LogManager.getLogger((String)"minepiece");
    private static final Map<Integer, List<TemperatureZone>> DIMENSION_ZONES = new HashMap<Integer, List<TemperatureZone>>();

    public static boolean addZone(int dimension, TemperatureZone zone) {
        List zones = DIMENSION_ZONES.computeIfAbsent(dimension, k -> new ArrayList());
        for (TemperatureZone existingZone : zones) {
            if (!existingZone.getName().equals(zone.getName())) continue;
            return false;
        }
        zones.add(zone);
        zones.sort(Comparator.comparingDouble(TemperatureZone::getPriority).reversed());
        return true;
    }

    public static boolean removeZone(int dimension, String zoneName) {
        List<TemperatureZone> zones = DIMENSION_ZONES.get(dimension);
        if (zones == null) {
            return false;
        }
        Iterator<TemperatureZone> iterator = zones.iterator();
        while (iterator.hasNext()) {
            TemperatureZone zone = iterator.next();
            if (!zone.getName().equals(zoneName)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Nullable
    public static TemperatureZone getZoneAt(World world, BlockPos pos) {
        int dimension = world.field_73011_w.getDimension();
        List<TemperatureZone> zones = DIMENSION_ZONES.get(dimension);
        if (zones == null || zones.isEmpty()) {
            return null;
        }
        for (TemperatureZone zone : zones) {
            if (!zone.contains(pos)) continue;
            return zone;
        }
        return null;
    }

    public static List<Map.Entry<TemperatureZone, Double>> getInfluencingZones(World world, BlockPos pos) {
        int dimension = world.field_73011_w.getDimension();
        List<TemperatureZone> zones = DIMENSION_ZONES.get(dimension);
        if (zones == null || zones.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<TemperatureZone, Double>> influencingZones = new ArrayList<Map.Entry<TemperatureZone, Double>>();
        for (TemperatureZone zone : zones) {
            double influence = zone.getInfluenceFactor(pos);
            if (!(influence > 0.0)) continue;
            influencingZones.add(new AbstractMap.SimpleEntry<TemperatureZone, Double>(zone, influence));
        }
        return influencingZones;
    }

    public static double getZoneTemperature(World world, BlockPos pos, double defaultTemp) {
        List<Map.Entry<TemperatureZone, Double>> influencingZones = TemperatureZones.getInfluencingZones(world, pos);
        if (influencingZones.isEmpty()) {
            return defaultTemp;
        }
        double highestPriority = influencingZones.get(0).getKey().getPriority();
        double tempSum = 0.0;
        double influenceSum = 0.0;
        ArrayList<Map.Entry<TemperatureZone, Double>> highPriorityZones = new ArrayList<Map.Entry<TemperatureZone, Double>>();
        for (Map.Entry<TemperatureZone, Double> entry : influencingZones) {
            TemperatureZone zone = entry.getKey();
            if (!(Math.abs(zone.getPriority() - highestPriority) < 1.0E-4)) continue;
            highPriorityZones.add(entry);
        }
        for (Map.Entry<TemperatureZone, Double> entry : highPriorityZones) {
            double influence = entry.getValue();
            tempSum += entry.getKey().getTemperature() * influence;
            influenceSum += influence;
        }
        if (influenceSum > 0.0) {
            double avgTemp = tempSum / influenceSum;
            double totalInfluence = Math.min(1.0, influenceSum);
            return avgTemp * totalInfluence + defaultTemp * (1.0 - totalInfluence);
        }
        return defaultTemp;
    }

    public static List<TemperatureZone> getZonesForDimension(int dimension) {
        return DIMENSION_ZONES.getOrDefault(dimension, Collections.emptyList());
    }

    public static void clearAllZones() {
        DIMENSION_ZONES.clear();
    }

    public static Map<Integer, List<TemperatureZone>> getAllDimensionZones() {
        HashMap<Integer, List<TemperatureZone>> result = new HashMap<Integer, List<TemperatureZone>>();
        for (Map.Entry<Integer, List<TemperatureZone>> entry : DIMENSION_ZONES.entrySet()) {
            result.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return result;
    }

    public static void visualizeZone(EntityPlayerMP player, TemperatureZone zone, int durationTicks) {
        BlockPos min = zone.getMinPos();
        BlockPos max = zone.getMaxPos();
        ModPackets.NETWORK.sendTo((IMessage)new VisualizeZonePacket(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p(), durationTicks, zone.getTemperature()), player);
    }

    public static void clearZonesForDimension(int dimension) {
        DIMENSION_ZONES.remove(dimension);
    }

    public static class TemperatureZone {
        private final String name;
        private final BlockPos minPos;
        private final BlockPos maxPos;
        private final double temperature;
        private final double blendRadius;
        private final double priority;

        public TemperatureZone(String name, BlockPos minPos, BlockPos maxPos, double temperature, double blendRadius, double priority) {
            this.name = name;
            this.minPos = new BlockPos(Math.min(minPos.func_177958_n(), maxPos.func_177958_n()), Math.min(minPos.func_177956_o(), maxPos.func_177956_o()), Math.min(minPos.func_177952_p(), maxPos.func_177952_p()));
            this.maxPos = new BlockPos(Math.max(minPos.func_177958_n(), maxPos.func_177958_n()), Math.max(minPos.func_177956_o(), maxPos.func_177956_o()), Math.max(minPos.func_177952_p(), maxPos.func_177952_p()));
            this.temperature = temperature;
            this.blendRadius = blendRadius;
            this.priority = priority;
        }

        public String getName() {
            return this.name;
        }

        public BlockPos getMinPos() {
            return this.minPos;
        }

        public BlockPos getMaxPos() {
            return this.maxPos;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public double getBlendRadius() {
            return this.blendRadius;
        }

        public double getPriority() {
            return this.priority;
        }

        public boolean contains(BlockPos pos) {
            return pos.func_177958_n() >= this.minPos.func_177958_n() && pos.func_177958_n() <= this.maxPos.func_177958_n() && pos.func_177956_o() >= this.minPos.func_177956_o() && pos.func_177956_o() <= this.maxPos.func_177956_o() && pos.func_177952_p() >= this.minPos.func_177952_p() && pos.func_177952_p() <= this.maxPos.func_177952_p();
        }

        public double distanceToBorder(BlockPos pos) {
            if (this.contains(pos)) {
                double distX = Math.min(pos.func_177958_n() - this.minPos.func_177958_n(), this.maxPos.func_177958_n() - pos.func_177958_n());
                double distY = Math.min(pos.func_177956_o() - this.minPos.func_177956_o(), this.maxPos.func_177956_o() - pos.func_177956_o());
                double distZ = Math.min(pos.func_177952_p() - this.minPos.func_177952_p(), this.maxPos.func_177952_p() - pos.func_177952_p());
                return -Math.min(Math.min(distX, distY), distZ);
            }
            double dx = Math.max(0, Math.max(this.minPos.func_177958_n() - pos.func_177958_n(), pos.func_177958_n() - this.maxPos.func_177958_n()));
            double dy = Math.max(0, Math.max(this.minPos.func_177956_o() - pos.func_177956_o(), pos.func_177956_o() - this.maxPos.func_177956_o()));
            double dz = Math.max(0, Math.max(this.minPos.func_177952_p() - pos.func_177952_p(), pos.func_177952_p() - this.maxPos.func_177952_p()));
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }

        public double getInfluenceFactor(BlockPos pos) {
            double distance = this.distanceToBorder(pos);
            if (distance <= -this.blendRadius) {
                return 1.0;
            }
            if (distance >= this.blendRadius) {
                return 0.0;
            }
            return 0.5 * (1.0 - distance / this.blendRadius) + 0.5;
        }
    }
}

