/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.SyncTemperatureZonesPacket;
import fr.minepiece.common.utils.TemperatureZones;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class TemperatureZoneSyncManager {
    private static final Map<Integer, Long> LAST_SYNC_TIME = new HashMap<Integer, Long>();
    private static final int SYNC_INTERVAL = 600;

    public static void triggerSync(int dimension) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        List<TemperatureZones.TemperatureZone> zones = TemperatureZones.getZonesForDimension(dimension);
        SyncTemperatureZonesPacket packet = new SyncTemperatureZonesPacket(dimension, zones);
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            if (player.field_71093_bK != dimension) continue;
            ModPackets.NETWORK.sendTo((IMessage)packet, player);
        }
        LAST_SYNC_TIME.put(dimension, Long.valueOf(server.func_71259_af()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int dimension = player.field_71093_bK;
            List<TemperatureZones.TemperatureZone> zones = TemperatureZones.getZonesForDimension(dimension);
            SyncTemperatureZonesPacket packet = new SyncTemperatureZonesPacket(dimension, zones);
            ModPackets.NETWORK.sendTo((IMessage)packet, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int dimension = player.field_71093_bK;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                boolean lastPlayerInDimension = true;
                for (EntityPlayerMP otherPlayer : server.func_184103_al().func_181057_v()) {
                    if (otherPlayer == player || otherPlayer.field_71093_bK != dimension) continue;
                    lastPlayerInDimension = false;
                    break;
                }
                if (lastPlayerInDimension) {
                    LAST_SYNC_TIME.remove(dimension);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int dimension = event.toDim;
            List<TemperatureZones.TemperatureZone> zones = TemperatureZones.getZonesForDimension(dimension);
            SyncTemperatureZonesPacket packet = new SyncTemperatureZonesPacket(dimension, zones);
            ModPackets.NETWORK.sendTo((IMessage)packet, player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null) {
                return;
            }
            long currentTime = server.func_71259_af();
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                int dimension = player.field_71093_bK;
                if (LAST_SYNC_TIME.containsKey(dimension) && currentTime - LAST_SYNC_TIME.get(dimension) < 600L) continue;
                TemperatureZoneSyncManager.triggerSync(dimension);
            }
        }
    }

    public static void onZoneAdded(int dimension) {
        TemperatureZoneSyncManager.triggerSync(dimension);
    }

    public static void onZoneRemoved(int dimension) {
        TemperatureZoneSyncManager.triggerSync(dimension);
    }
}

