/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.minepiece.MinePiece;
import fr.minepiece.common.utils.TemperatureZones;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class TemperatureZoneConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;

    public static void initialize(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "minepiece");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((configFile = new File(configDir, "temperature_zones.json")).exists()) {
            TemperatureZoneConfigManager.loadConfig();
        }
    }

    public static boolean saveConfig() {
        try {
            JsonObject root = new JsonObject();
            for (Map.Entry<Integer, List<TemperatureZones.TemperatureZone>> entry : TemperatureZoneConfigManager.getAllZones().entrySet()) {
                int dimension = entry.getKey();
                List<TemperatureZones.TemperatureZone> zones = entry.getValue();
                if (zones.isEmpty()) continue;
                JsonArray zonesArray = new JsonArray();
                for (TemperatureZones.TemperatureZone zone : zones) {
                    JsonObject zoneObj = new JsonObject();
                    zoneObj.addProperty("name", zone.getName());
                    BlockPos minPos = zone.getMinPos();
                    BlockPos maxPos = zone.getMaxPos();
                    JsonObject posMinObj = new JsonObject();
                    posMinObj.addProperty("x", (Number)minPos.func_177958_n());
                    posMinObj.addProperty("y", (Number)minPos.func_177956_o());
                    posMinObj.addProperty("z", (Number)minPos.func_177952_p());
                    JsonObject posMaxObj = new JsonObject();
                    posMaxObj.addProperty("x", (Number)maxPos.func_177958_n());
                    posMaxObj.addProperty("y", (Number)maxPos.func_177956_o());
                    posMaxObj.addProperty("z", (Number)maxPos.func_177952_p());
                    zoneObj.add("minPos", (JsonElement)posMinObj);
                    zoneObj.add("maxPos", (JsonElement)posMaxObj);
                    zoneObj.addProperty("temperature", (Number)zone.getTemperature());
                    zoneObj.addProperty("blendRadius", (Number)zone.getBlendRadius());
                    zoneObj.addProperty("priority", (Number)zone.getPriority());
                    zonesArray.add((JsonElement)zoneObj);
                }
                root.add("dimension_" + dimension, (JsonElement)zonesArray);
            }
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            MinePiece.LOGGER.info("Zones de temp\u00e9rature sauvegard\u00e9es avec succ\u00e8s");
            return true;
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors de la sauvegarde des zones de temp\u00e9rature", (Throwable)e);
            return false;
        }
    }

    public static boolean loadConfig() {
        try {
            if (!configFile.exists()) {
                return false;
            }
            TemperatureZones.clearAllZones();
            try (FileReader reader = new FileReader(configFile);){
                JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                for (Map.Entry dimensionEntry : root.entrySet()) {
                    int dimension;
                    if (!((String)dimensionEntry.getKey()).startsWith("dimension_")) continue;
                    String dimStr = ((String)dimensionEntry.getKey()).substring("dimension_".length());
                    try {
                        dimension = Integer.parseInt(dimStr);
                    }
                    catch (NumberFormatException e) {
                        MinePiece.LOGGER.warn("Format d'ID de dimension invalide: " + dimStr);
                        continue;
                    }
                    JsonArray zonesArray = ((JsonElement)dimensionEntry.getValue()).getAsJsonArray();
                    for (JsonElement zoneElem : zonesArray) {
                        JsonObject zoneObj = zoneElem.getAsJsonObject();
                        String name = zoneObj.get("name").getAsString();
                        JsonObject minPosObj = zoneObj.get("minPos").getAsJsonObject();
                        JsonObject maxPosObj = zoneObj.get("maxPos").getAsJsonObject();
                        BlockPos minPos = new BlockPos(minPosObj.get("x").getAsInt(), minPosObj.get("y").getAsInt(), minPosObj.get("z").getAsInt());
                        BlockPos maxPos = new BlockPos(maxPosObj.get("x").getAsInt(), maxPosObj.get("y").getAsInt(), maxPosObj.get("z").getAsInt());
                        double temperature = zoneObj.get("temperature").getAsDouble();
                        double blendRadius = zoneObj.get("blendRadius").getAsDouble();
                        double priority = zoneObj.get("priority").getAsDouble();
                        TemperatureZones.TemperatureZone zone = new TemperatureZones.TemperatureZone(name, minPos, maxPos, temperature, blendRadius, priority);
                        TemperatureZones.addZone(dimension, zone);
                    }
                }
            }
            MinePiece.LOGGER.info("Zones de temp\u00e9rature charg\u00e9es avec succ\u00e8s");
            return true;
        }
        catch (JsonParseException | IOException e) {
            MinePiece.LOGGER.error("Erreur lors du chargement des zones de temp\u00e9rature", e);
            return false;
        }
    }

    private static Map<Integer, List<TemperatureZones.TemperatureZone>> getAllZones() {
        return TemperatureZones.getAllDimensionZones();
    }
}

