/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.minepiece.MinePiece;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.temperature.DefaultTemperature;
import fr.minepiece.common.capability.temperature.RaceTemperatureModifiers;
import fr.minepiece.common.utils.BiomeTemperatures;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class TemperatureConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;

    public static void initialize(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "minepiece");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((configFile = new File(configDir, "temperature_config.json")).exists()) {
            TemperatureConfigManager.loadConfig();
        } else {
            TemperatureConfigManager.saveDefaultConfig();
        }
    }

    public static void saveConfig() {
        try {
            JsonObject root = new JsonObject();
            JsonObject raceTemps = new JsonObject();
            for (MinePieceRaces race : MinePieceRaces.values()) {
                raceTemps.addProperty(race.name(), (Number)RaceTemperatureModifiers.getRaceBaseTemperature(race));
            }
            root.add("race_temperatures", (JsonElement)raceTemps);
            JsonObject biomeTemps = new JsonObject();
            for (Map.Entry<String, Double> entry : BiomeTemperatures.getAllBiomeTemperatures().entrySet()) {
                biomeTemps.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            root.add("biome_temperatures", (JsonElement)biomeTemps);
            root.addProperty("update_interval", (Number)DefaultTemperature.getUpdateInterval());
            root.addProperty("temperature_change_rate", (Number)DefaultTemperature.getDefaultTempChange());
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            MinePiece.LOGGER.info("Configuration de temp\u00e9rature sauvegard\u00e9e avec succ\u00e8s");
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors de la sauvegarde de la configuration de temp\u00e9rature", (Throwable)e);
        }
    }

    public static void loadConfig() {
        try {
            JsonObject root;
            if (!configFile.exists()) {
                TemperatureConfigManager.saveDefaultConfig();
                return;
            }
            FileReader reader = new FileReader(configFile);
            Iterator iterator = null;
            try {
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (iterator != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            if (root.has("race_temperatures")) {
                JsonObject raceTemps = root.getAsJsonObject("race_temperatures");
                for (Map.Entry entry : raceTemps.entrySet()) {
                    try {
                        MinePieceRaces race = MinePieceRaces.valueOf((String)entry.getKey());
                        double temperature = ((JsonElement)entry.getValue()).getAsDouble();
                        RaceTemperatureModifiers.setRaceBaseTemperature(race, temperature);
                    }
                    catch (IllegalArgumentException e) {
                        MinePiece.LOGGER.warn("Race inconnue dans la configuration : " + (String)entry.getKey());
                    }
                }
            }
            if (root.has("biome_temperatures")) {
                JsonObject biomeTemps = root.getAsJsonObject("biome_temperatures");
                for (Map.Entry entry : biomeTemps.entrySet()) {
                    BiomeTemperatures.registerBiomeTemperature((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
                }
            }
            if (root.has("update_interval")) {
                DefaultTemperature.setUpdateInterval(root.get("update_interval").getAsInt());
            }
            if (root.has("temperature_change_rate")) {
                DefaultTemperature.setDefaultTempChange(root.get("temperature_change_rate").getAsDouble());
            }
            MinePiece.LOGGER.info("Configuration de temp\u00e9rature charg\u00e9e avec succ\u00e8s");
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors du chargement de la configuration de temp\u00e9rature", (Throwable)e);
        }
    }

    private static void saveDefaultConfig() {
        TemperatureConfigManager.saveConfig();
    }
}

