/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;

public class CooldownUtils {
    public static boolean cooldownPassed(EntityPlayer player, String cooldownId) {
        if (player.hasCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null)) {
            IMinePieceCooldown cooldownCap = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
            long cooldownEndTime = cooldownCap.getCooldown(cooldownId);
            return cooldownEndTime == -1L || System.currentTimeMillis() >= cooldownEndTime;
        }
        return true;
    }

    public static void setCooldown(EntityPlayer player, String cooldownId, Item item, long durationMs) {
        if (player.hasCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null)) {
            IMinePieceCooldown cooldownCap = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
            long cooldownEndTime = System.currentTimeMillis() + durationMs;
            cooldownCap.setCooldown(cooldownId, cooldownEndTime);
            if (player instanceof EntityPlayerMP) {
                cooldownCap.clientSync((EntityPlayerMP)player);
            }
        }
        int cooldownTicks = (int)(durationMs / 50L);
        player.func_184811_cZ().func_185145_a(item, cooldownTicks);
    }

    public static long getRemainingCooldown(EntityPlayer player, String cooldownId) {
        IMinePieceCooldown cooldownCap;
        long cooldownEndTime;
        if (player.hasCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null) && (cooldownEndTime = (cooldownCap = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null)).getCooldown(cooldownId)) != -1L) {
            long remaining = cooldownEndTime - System.currentTimeMillis();
            return remaining > 0L ? remaining : 0L;
        }
        return 0L;
    }
}

