/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.minepiece.MinePiece;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClusterConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    private static int depletedRegrowthTimeTest;
    private static int smallRegrowthTimeTest;
    private static int mediumRegrowthTimeTest;
    private static int depletedRegrowthTimeProd;
    private static int smallRegrowthTimeProd;
    private static int mediumRegrowthTimeProd;
    private static int smallDropCount;
    private static int mediumMinDropCount;
    private static int mediumMaxDropCount;
    private static int bigMinDropCount;
    private static int bigMaxDropCount;
    private static boolean testMode;

    public static void initialize(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "minepiece");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((configFile = new File(configDir, "cluster_config.json")).exists()) {
            ClusterConfigManager.loadConfig();
        } else {
            ClusterConfigManager.saveDefaultConfig();
        }
        MinePiece.LOGGER.info("Configuration des clusters initialis\u00e9e avec succ\u00e8s");
    }

    public static void saveConfig() {
        try {
            JsonObject root = new JsonObject();
            JsonObject regrowthTimesTest = new JsonObject();
            regrowthTimesTest.addProperty("depleted", (Number)depletedRegrowthTimeTest);
            regrowthTimesTest.addProperty("small", (Number)smallRegrowthTimeTest);
            regrowthTimesTest.addProperty("medium", (Number)mediumRegrowthTimeTest);
            JsonObject regrowthTimesProd = new JsonObject();
            regrowthTimesProd.addProperty("depleted", (Number)depletedRegrowthTimeProd);
            regrowthTimesProd.addProperty("small", (Number)smallRegrowthTimeProd);
            regrowthTimesProd.addProperty("medium", (Number)mediumRegrowthTimeProd);
            JsonObject regrowthTimes = new JsonObject();
            regrowthTimes.add("test", (JsonElement)regrowthTimesTest);
            regrowthTimes.add("production", (JsonElement)regrowthTimesProd);
            root.add("regrowth_times", (JsonElement)regrowthTimes);
            JsonObject dropCounts = new JsonObject();
            dropCounts.addProperty("small", (Number)smallDropCount);
            JsonObject mediumDrop = new JsonObject();
            mediumDrop.addProperty("min", (Number)mediumMinDropCount);
            mediumDrop.addProperty("max", (Number)mediumMaxDropCount);
            dropCounts.add("medium", (JsonElement)mediumDrop);
            JsonObject bigDrop = new JsonObject();
            bigDrop.addProperty("min", (Number)bigMinDropCount);
            bigDrop.addProperty("max", (Number)bigMaxDropCount);
            dropCounts.add("big", (JsonElement)bigDrop);
            root.add("drop_counts", (JsonElement)dropCounts);
            root.addProperty("test_mode", Boolean.valueOf(testMode));
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            MinePiece.LOGGER.info("Configuration des clusters sauvegard\u00e9e avec succ\u00e8s");
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors de la sauvegarde de la configuration des clusters", (Throwable)e);
        }
    }

    public static void loadConfig() {
        try {
            JsonObject root;
            if (!configFile.exists()) {
                ClusterConfigManager.saveDefaultConfig();
                return;
            }
            try (FileReader reader = new FileReader(configFile);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            if (root.has("regrowth_times")) {
                JsonObject regrowthTimes = root.getAsJsonObject("regrowth_times");
                if (regrowthTimes.has("test")) {
                    JsonObject testTimes = regrowthTimes.getAsJsonObject("test");
                    if (testTimes.has("depleted")) {
                        depletedRegrowthTimeTest = testTimes.get("depleted").getAsInt();
                    }
                    if (testTimes.has("small")) {
                        smallRegrowthTimeTest = testTimes.get("small").getAsInt();
                    }
                    if (testTimes.has("medium")) {
                        mediumRegrowthTimeTest = testTimes.get("medium").getAsInt();
                    }
                }
                if (regrowthTimes.has("production")) {
                    JsonObject prodTimes = regrowthTimes.getAsJsonObject("production");
                    if (prodTimes.has("depleted")) {
                        depletedRegrowthTimeProd = prodTimes.get("depleted").getAsInt();
                    }
                    if (prodTimes.has("small")) {
                        smallRegrowthTimeProd = prodTimes.get("small").getAsInt();
                    }
                    if (prodTimes.has("medium")) {
                        mediumRegrowthTimeProd = prodTimes.get("medium").getAsInt();
                    }
                }
            }
            if (root.has("drop_counts")) {
                JsonObject dropCounts = root.getAsJsonObject("drop_counts");
                if (dropCounts.has("small")) {
                    smallDropCount = dropCounts.get("small").getAsInt();
                }
                if (dropCounts.has("medium")) {
                    JsonObject mediumDrop = dropCounts.getAsJsonObject("medium");
                    if (mediumDrop.has("min")) {
                        mediumMinDropCount = mediumDrop.get("min").getAsInt();
                    }
                    if (mediumDrop.has("max")) {
                        mediumMaxDropCount = mediumDrop.get("max").getAsInt();
                    }
                }
                if (dropCounts.has("big")) {
                    JsonObject bigDrop = dropCounts.getAsJsonObject("big");
                    if (bigDrop.has("min")) {
                        bigMinDropCount = bigDrop.get("min").getAsInt();
                    }
                    if (bigDrop.has("max")) {
                        bigMaxDropCount = bigDrop.get("max").getAsInt();
                    }
                }
            }
            if (root.has("test_mode")) {
                testMode = root.get("test_mode").getAsBoolean();
            }
            MinePiece.LOGGER.info("Configuration des clusters charg\u00e9e avec succ\u00e8s");
        }
        catch (IOException e) {
            MinePiece.LOGGER.error("Erreur lors du chargement de la configuration des clusters", (Throwable)e);
        }
    }

    private static void saveDefaultConfig() {
        ClusterConfigManager.saveConfig();
    }

    public static int getDepletedRegrowthTime() {
        return testMode ? depletedRegrowthTimeTest : depletedRegrowthTimeProd;
    }

    public static void setDepletedRegrowthTime(int time) {
        if (testMode) {
            depletedRegrowthTimeTest = time;
        } else {
            depletedRegrowthTimeProd = time;
        }
    }

    public static int getSmallRegrowthTime() {
        return testMode ? smallRegrowthTimeTest : smallRegrowthTimeProd;
    }

    public static void setSmallRegrowthTime(int time) {
        if (testMode) {
            smallRegrowthTimeTest = time;
        } else {
            smallRegrowthTimeProd = time;
        }
    }

    public static int getMediumRegrowthTime() {
        return testMode ? mediumRegrowthTimeTest : mediumRegrowthTimeProd;
    }

    public static void setMediumRegrowthTime(int time) {
        if (testMode) {
            mediumRegrowthTimeTest = time;
        } else {
            mediumRegrowthTimeProd = time;
        }
    }

    public static int getDepletedRegrowthTimeTest() {
        return depletedRegrowthTimeTest;
    }

    public static int getSmallRegrowthTimeTest() {
        return smallRegrowthTimeTest;
    }

    public static int getMediumRegrowthTimeTest() {
        return mediumRegrowthTimeTest;
    }

    public static int getDepletedRegrowthTimeProd() {
        return depletedRegrowthTimeProd;
    }

    public static int getSmallRegrowthTimeProd() {
        return smallRegrowthTimeProd;
    }

    public static int getMediumRegrowthTimeProd() {
        return mediumRegrowthTimeProd;
    }

    public static int getSmallDropCount() {
        return smallDropCount;
    }

    public static void setSmallDropCount(int count) {
        smallDropCount = count;
    }

    public static int getMediumMinDropCount() {
        return mediumMinDropCount;
    }

    public static void setMediumMinDropCount(int count) {
        mediumMinDropCount = count;
    }

    public static int getMediumMaxDropCount() {
        return mediumMaxDropCount;
    }

    public static void setMediumMaxDropCount(int count) {
        mediumMaxDropCount = count;
    }

    public static int getBigMinDropCount() {
        return bigMinDropCount;
    }

    public static void setBigMinDropCount(int count) {
        bigMinDropCount = count;
    }

    public static int getBigMaxDropCount() {
        return bigMaxDropCount;
    }

    public static void setBigMaxDropCount(int count) {
        bigMaxDropCount = count;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public static boolean toggleTestMode() {
        ClusterConfigManager.setTestMode(!testMode);
        return testMode;
    }

    static {
        depletedRegrowthTimeTest = 100;
        smallRegrowthTimeTest = 200;
        mediumRegrowthTimeTest = 400;
        depletedRegrowthTimeProd = 18000;
        smallRegrowthTimeProd = 36000;
        mediumRegrowthTimeProd = 72000;
        smallDropCount = 1;
        mediumMinDropCount = 2;
        mediumMaxDropCount = 5;
        bigMinDropCount = 6;
        bigMaxDropCount = 10;
        testMode = true;
    }
}

