/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import fr.minepiece.common.utils.TemperatureZones;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BiomeTemperatures {
    private static final Map<String, Double> BIOME_MAX_TEMPERATURES = new HashMap<String, Double>();
    private static final Set<Block> WARMING_BLOCKS = new HashSet<Block>();
    private static final Set<Block> HEAT_SOURCES = new HashSet<Block>();
    private static final double DEFAULT_TEMPERATURE = 20.0;
    private static final double NIGHT_TEMPERATURE_MODIFIER = -10.0;
    private static final double WATER_COOLING_MULTIPLIER = 1.05;
    private static final int HEAT_SOURCE_CHECK_RADIUS = 4;
    private static final int WARMING_BLOCK_CHECK_RADIUS = 2;

    public static void registerBiomeTemperature(String biomeName, double temperature) {
        BIOME_MAX_TEMPERATURES.put(biomeName, temperature);
    }

    public static Map<String, Double> getAllBiomeTemperatures() {
        return new HashMap<String, Double>(BIOME_MAX_TEMPERATURES);
    }

    public static boolean isNearWarmingBlock(World world, BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (!WARMING_BLOCKS.contains(world.func_180495_p(checkPos).func_177230_c())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double getHeatSourceEffect(World world, BlockPos pos) {
        double maxEffect = 0.0;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    Block block = world.func_180495_p(checkPos).func_177230_c();
                    if (!HEAT_SOURCES.contains(block)) continue;
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    double effect = (4.0 - distance) / 4.0;
                    effect = Math.max(0.0, effect);
                    maxEffect = Math.max(maxEffect, effect);
                }
            }
        }
        return maxEffect * 4.0;
    }

    public static double getWaterEffect(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            return 1.05;
        }
        return 1.0;
    }

    public static double getDayNightModifier(long worldTime) {
        long timeOfDay = worldTime % 24000L;
        if (timeOfDay <= 6000L) {
            return -10.0 * (1.0 - (double)timeOfDay / 6000.0);
        }
        if (timeOfDay <= 18000L) {
            return -10.0 * ((double)(timeOfDay - 6000L) / 12000.0);
        }
        return -10.0 * (1.0 - (double)(24000L - timeOfDay) / 6000.0);
    }

    public static double getBiomeTemperature(Biome biome, long worldTime) {
        String biomeName = biome.getRegistryName().toString();
        double maxTemp = BIOME_MAX_TEMPERATURES.getOrDefault(biomeName, 20.0);
        return maxTemp + BiomeTemperatures.getDayNightModifier(worldTime);
    }

    public static double getAdjustedTemperature(double baseTemp, int y) {
        if (y > 110) {
            return baseTemp - (double)(y - 64) / 100.0;
        }
        return baseTemp;
    }

    public static double getArmorInsulation(EntityPlayer player) {
        double insulation = 0.0;
        for (ItemStack armor : player.func_184193_aE()) {
            if (armor.func_190926_b()) continue;
            insulation += 0.1;
        }
        return 1.0 - insulation;
    }

    public static double getFinalEnvironmentTemperature(World world, BlockPos pos, long worldTime) {
        Double zoneTemp = BiomeTemperatures.getZoneTemperatureIfApplicable(world, pos);
        if (zoneTemp != null) {
            return zoneTemp;
        }
        Biome biome = world.func_180494_b(pos);
        double baseTemp = BiomeTemperatures.getBiomeTemperature(biome, worldTime);
        double adjustedTemp = BiomeTemperatures.getAdjustedTemperature(baseTemp, pos.func_177956_o());
        adjustedTemp += BiomeTemperatures.getHeatSourceEffect(world, pos);
        if (BiomeTemperatures.isNearWarmingBlock(world, pos)) {
            adjustedTemp = Math.max(adjustedTemp, 20.0);
        }
        return adjustedTemp;
    }

    private static Double getZoneTemperatureIfApplicable(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        String biomeName = biome.getRegistryName().toString();
        double defaultTemp = BIOME_MAX_TEMPERATURES.getOrDefault(biomeName, 20.0);
        double zoneTemp = TemperatureZones.getZoneTemperature(world, pos, defaultTemp);
        if (Math.abs(zoneTemp - defaultTemp) > 0.01) {
            return zoneTemp;
        }
        return null;
    }

    public static boolean isHoldingTorch(EntityPlayer player) {
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        boolean mainHandTorch = !mainHand.func_190926_b() && (Item.func_150898_a((Block)Blocks.field_150478_aa).equals(mainHand.func_77973_b()) || Item.func_150898_a((Block)Blocks.field_150429_aA).equals(mainHand.func_77973_b()));
        boolean offHandTorch = !offHand.func_190926_b() && (Item.func_150898_a((Block)Blocks.field_150478_aa).equals(offHand.func_77973_b()) || Item.func_150898_a((Block)Blocks.field_150429_aA).equals(offHand.func_77973_b()));
        return mainHandTorch || offHandTorch;
    }

    static {
        BiomeTemperatures.registerBiomeTemperature("minecraft:ocean", 8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:deep_ocean", 4.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:plains", 18.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:forest", 15.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:birch_forest", 15.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:birch_forest_hills", 15.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:roofed_forest", 15.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:swampland", 22.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:river", 12.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:stone_beach", 20.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:extreme_hills", 10.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:extreme_hills_with_trees", 10.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:smaller_extreme_hills", 10.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mutated_extreme_hills", 10.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mutated_extreme_hills_with_trees", 10.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:beaches", 25.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:desert", 40.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:desert_hills", 40.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:savanna", 30.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:savanna_rock", 30.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:jungle", 35.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:jungle_hills", 35.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:jungle_edge", 35.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mesa", 33.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mesa_rock", 33.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mesa_clear_rock", 33.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:ice_flats", -5.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:ice_mountains", -5.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:frozen_river", -5.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:frozen_ocean", -5.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:cold_beach", -5.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:taiga", -8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:taiga_hills", -8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:taiga_cold", -8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:taiga_cold_hills", -8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mutated_taiga", -8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mutated_taiga_cold", -8.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:extreme_hills_with_snow", 0.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mushroom_island", 20.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:mushroom_island_shore", 20.0);
        BiomeTemperatures.registerBiomeTemperature("minecraft:sky", 0.0);
        WARMING_BLOCKS.add(Blocks.field_150478_aa);
        WARMING_BLOCKS.add(Blocks.field_150429_aA);
        WARMING_BLOCKS.add(Blocks.field_150426_aN);
        WARMING_BLOCKS.add(Blocks.field_150470_am);
        WARMING_BLOCKS.add(Blocks.field_150428_aP);
        WARMING_BLOCKS.add(Blocks.field_180398_cJ);
        HEAT_SOURCES.add((Block)Blocks.field_150480_ab);
        HEAT_SOURCES.add((Block)Blocks.field_150353_l);
        HEAT_SOURCES.add((Block)Blocks.field_150356_k);
        HEAT_SOURCES.add(Blocks.field_150432_aD);
        HEAT_SOURCES.add(Blocks.field_150403_cj);
        HEAT_SOURCES.add(Blocks.field_185778_de);
        HEAT_SOURCES.add(Blocks.field_150433_aE);
        HEAT_SOURCES.add(Blocks.field_150431_aC);
    }
}

