/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.utils;

import fr.minepiece.common.init.ModItems;
import fr.minepiece.common.utils.ItemGiftUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class BerryUtils {
    private static final int[] BERRY_VALUES = new int[]{1, 5, 10, 50, 100, 500, 1000, 5000, 10000, 100000, 1000000, 5000000, 10000000};
    private static final int[][] LEVEL_REWARDS = new int[][]{{1, 0}, {2, 1000}, {3, 1500}, {4, 2000}, {5, 2500}, {6, 3000}, {7, 3500}, {8, 4000}, {9, 4500}, {10, 5000}, {11, 5500}, {12, 6000}, {13, 6500}, {14, 7000}, {15, 7500}, {16, 8000}, {17, 8500}, {18, 9000}, {19, 9500}, {20, 10000}, {21, 11000}, {22, 12000}, {23, 13000}, {24, 14000}, {25, 15000}, {26, 20000}, {27, 25000}, {28, 30000}, {29, 35000}, {30, 50000}};

    public static Map<Integer, Integer> calculateBerryDistribution(int targetLevel) {
        int rewardAmount = -1;
        for (int[] levelReward : LEVEL_REWARDS) {
            if (levelReward[0] != targetLevel) continue;
            rewardAmount = levelReward[1];
            break;
        }
        if (rewardAmount == -1) {
            System.out.println("Niveau non trouv\u00e9!");
            return null;
        }
        HashMap<Integer, Integer> distribution = new HashMap<Integer, Integer>();
        int remaining = rewardAmount;
        for (int meta = BERRY_VALUES.length - 1; meta >= 0 && remaining > 0; --meta) {
            int berryValue = BERRY_VALUES[meta];
            if (remaining < berryValue) continue;
            int count = remaining / berryValue;
            distribution.put(meta, count);
            remaining -= count * berryValue;
        }
        return distribution;
    }

    public static boolean giveBerries(EntityPlayer player, int level) {
        if (player.field_70170_p.field_72995_K || level <= 0) {
            return false;
        }
        Map<Integer, Integer> distribution = BerryUtils.calculateBerryDistribution(level);
        if (distribution == null) {
            return false;
        }
        boolean allGiven = true;
        for (Map.Entry<Integer, Integer> entry : distribution.entrySet()) {
            int meta = entry.getKey();
            int count = entry.getValue();
            ItemGiftUtils.giveItemToPlayer(player, ModItems.BERRY, count, meta);
        }
        return allGiven;
    }
}

