/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets.races;

import fr.minepiece.client.interactions.ClientController;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TontattaHealthBoostPacket
implements IMessage,
IMessageHandler<TontattaHealthBoostPacket, IMessage> {
    private int entityId;
    private double x;
    private double y;
    private double z;

    public TontattaHealthBoostPacket() {
    }

    public TontattaHealthBoostPacket(int entityId, double x, double y, double z) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public IMessage onMessage(TontattaHealthBoostPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            ClientController.handleEvent(ClientController.Events.TONTATTA_HEALTH_BOOST, message);
        }
        return null;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

