/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets.races;

import fr.minepiece.client.particles.ModParticles;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SpawnParticlePacket
implements IMessage,
IMessageHandler<SpawnParticlePacket, IMessage> {
    private EnumParticleTypes particleType;
    private double xPos;
    private double yPos;
    private double zPos;

    public SpawnParticlePacket() {
    }

    public SpawnParticlePacket(EnumParticleTypes particleType, double xPos, double yPos, double zPos) {
        this.particleType = particleType;
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
    }

    public void fromBytes(ByteBuf buf) {
        this.particleType = EnumParticleTypes.values()[buf.readInt()];
        this.xPos = buf.readDouble();
        this.yPos = buf.readDouble();
        this.zPos = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particleType.ordinal());
        buf.writeDouble(this.xPos);
        buf.writeDouble(this.yPos);
        buf.writeDouble(this.zPos);
    }

    public IMessage onMessage(SpawnParticlePacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            ModParticles.spawnParticle(message.particleType, message.xPos, message.yPos, message.zPos);
        }
        return null;
    }
}

