/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets.races;

import fr.minepiece.client.interactions.ClientController;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticleVortexPacket
implements IMessage,
IMessageHandler<ParticleVortexPacket, IMessage> {
    private ArrayList<Vec3d> coordinates;

    public ParticleVortexPacket() {
    }

    public ParticleVortexPacket(ArrayList<Vec3d> coordinates) {
        this.coordinates = coordinates;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.coordinates = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.coordinates.add(new Vec3d(x, y, z));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.coordinates.size());
        for (Vec3d vec3d : this.coordinates) {
            buf.writeDouble(vec3d.field_72450_a);
            buf.writeDouble(vec3d.field_72448_b);
            buf.writeDouble(vec3d.field_72449_c);
        }
    }

    public ArrayList<Vec3d> getCoordinates() {
        return this.coordinates;
    }

    public IMessage onMessage(ParticleVortexPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            ClientController.handleEvent(ClientController.Events.GIANT_IKOKU, message);
        }
        return null;
    }
}

