/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets.races;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DamagePacket
implements IMessage,
IMessageHandler<DamagePacket, IMessage> {
    private double damage;
    private int entityIdToDamage;
    private String usernameDamageDealer;
    private Types damageType;

    public DamagePacket() {
    }

    public DamagePacket(int entityIdToDamage, double damage, String usernameDamageDealer) {
        this.entityIdToDamage = entityIdToDamage;
        this.damage = damage;
        this.usernameDamageDealer = usernameDamageDealer;
    }

    public DamagePacket(int entityIdToDamage, Types damageType, String usernameDamageDealer) {
        this.entityIdToDamage = entityIdToDamage;
        this.usernameDamageDealer = usernameDamageDealer;
        this.damageType = damageType;
    }

    public void fromBytes(ByteBuf buf) {
        boolean hasDamageType;
        this.entityIdToDamage = buf.readInt();
        this.damage = buf.readDouble();
        boolean hasDamageDealer = buf.readBoolean();
        if (hasDamageDealer) {
            this.usernameDamageDealer = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        if (hasDamageType = buf.readBoolean()) {
            this.damageType = Types.values()[buf.readInt()];
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityIdToDamage);
        buf.writeDouble(this.damage);
        if (this.usernameDamageDealer != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.usernameDamageDealer);
        } else {
            buf.writeBoolean(false);
        }
        if (this.damageType != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.damageType.ordinal());
        } else {
            buf.writeBoolean(false);
        }
    }

    public IMessage onMessage(DamagePacket message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            int entityId = message.getEntityIdToDamage();
            boolean isDamageType = message.getDamageType() != null;
            System.out.println("received " + isDamageType + " " + (Object)((Object)message.getDamageType()) + ", player name: " + message.getUsernameDamageDealer());
            double damage = isDamageType ? (double)message.getDamageType().getDamage() : message.getDamage();
            String damageDealerUsername = message.getUsernameDamageDealer();
            Entity targetEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(entityId);
            if (targetEntity instanceof EntityLivingBase) {
                EntityLivingBase targetEntityLiving = (EntityLivingBase)targetEntity;
                EntityPlayer dealingEntity = null;
                if (damageDealerUsername != null) {
                    dealingEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_72924_a(damageDealerUsername);
                }
                DamageSource damageSource = dealingEntity != null ? DamageSource.func_76365_a(dealingEntity) : DamageSource.field_76377_j;
                MinecraftServer server = ctx.getServerHandler().field_147369_b.func_184102_h();
                if (server != null) {
                    server.func_152344_a(() -> targetEntityLiving.func_70097_a(damageSource, (float)damage));
                }
                if (isDamageType && server != null && message.getDamageType() == Types.MINKS_SHOCKWAVE) {
                    server.func_152344_a(() -> targetEntityLiving.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness"), 80, 6)));
                }
            }
        }
        return null;
    }

    public double getDamage() {
        return this.damage;
    }

    public int getEntityIdToDamage() {
        return this.entityIdToDamage;
    }

    public String getUsernameDamageDealer() {
        return this.usernameDamageDealer;
    }

    public Types getDamageType() {
        return this.damageType;
    }

    public static enum Types {
        CYBORG_LASER_BEAM(8),
        MINKS_SHOCKWAVE(6);

        final int damage;

        private Types(int damage) {
            this.damage = damage;
        }

        public int getDamage() {
            return this.damage;
        }
    }
}

