/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets.races;

import fr.minepiece.common.api.abilities.races.cyborg.CyborgBeamPacket;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgLaserAbility;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CyborgLaserSyncingPacket
implements IMessage,
IMessageHandler<CyborgLaserSyncingPacket, IMessage> {
    private HashMap<CyborgBeamPacket, Double> beamsToRender;

    public CyborgLaserSyncingPacket() {
    }

    public CyborgLaserSyncingPacket(HashMap<CyborgBeamPacket, Double> beamsToRender) {
        this.beamsToRender = beamsToRender;
    }

    public void fromBytes(ByteBuf buf) {
        int beamsToRenderSize = buf.readInt();
        this.beamsToRender = new HashMap(beamsToRenderSize);
        for (int i = 0; i < beamsToRenderSize; ++i) {
            CyborgBeamPacket beamPacket = new CyborgBeamPacket();
            beamPacket.fromBytes(buf);
            double doubleValue = buf.readDouble();
            this.beamsToRender.put(beamPacket, doubleValue);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.beamsToRender.size());
        for (Map.Entry<CyborgBeamPacket, Double> entry : this.beamsToRender.entrySet()) {
            entry.getKey().toBytes(buf);
            buf.writeDouble(entry.getValue().doubleValue());
        }
    }

    public IMessage onMessage(CyborgLaserSyncingPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            CyborgLaserAbility.beamsToRender = message.beamsToRender;
        }
        return null;
    }
}

