/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets.races;

import fr.minepiece.client.interactions.ClientController;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CyborgFlameThrowerPacket
implements IMessage,
IMessageHandler<CyborgFlameThrowerPacket, IMessage> {
    private ArrayList<Vec3d> coordinates;

    public CyborgFlameThrowerPacket(ArrayList<Vec3d> coordinates) {
        this.coordinates = coordinates;
    }

    public CyborgFlameThrowerPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.coordinates = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.coordinates.add(new Vec3d(x, y, z));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.coordinates.size());
        for (Vec3d vec3d : this.coordinates) {
            buf.writeDouble(vec3d.field_72450_a);
            buf.writeDouble(vec3d.field_72448_b);
            buf.writeDouble(vec3d.field_72449_c);
        }
    }

    public IMessage onMessage(CyborgFlameThrowerPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            ClientController.handleEvent(ClientController.Events.CYBORG_FLAMETHROWER, message);
        }
        return null;
    }

    private World getServerWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.func_71121_q();
    }

    public ArrayList<Vec3d> getCoordinates() {
        return this.coordinates;
    }
}

