/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.client.visual.TemperatureZoneRenderer;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class VisualizeZonePacket
implements IMessage,
IMessageHandler<VisualizeZonePacket, IMessage> {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int durationTicks;
    private double temperature;

    public VisualizeZonePacket() {
    }

    public VisualizeZonePacket(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int durationTicks, double temperature) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.durationTicks = durationTicks;
        this.temperature = temperature;
    }

    public void fromBytes(ByteBuf buf) {
        this.minX = buf.readInt();
        this.minY = buf.readInt();
        this.minZ = buf.readInt();
        this.maxX = buf.readInt();
        this.maxY = buf.readInt();
        this.maxZ = buf.readInt();
        this.durationTicks = buf.readInt();
        this.temperature = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.minX);
        buf.writeInt(this.minY);
        buf.writeInt(this.minZ);
        buf.writeInt(this.maxX);
        buf.writeInt(this.maxY);
        buf.writeInt(this.maxZ);
        buf.writeInt(this.durationTicks);
        buf.writeDouble(this.temperature);
    }

    public IMessage onMessage(VisualizeZonePacket message, MessageContext ctx) {
        Minecraft mc;
        if (ctx.side.isClient() && (mc = Minecraft.func_71410_x()) != null) {
            mc.func_152344_a(() -> {
                try {
                    TemperatureZoneRenderer.addZoneToRender(message.minX, message.minY, message.minZ, message.maxX, message.maxY, message.maxZ, message.durationTicks, message.temperature);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return null;
    }
}

