/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThirstSyncPacket
implements IMessage,
IMessageHandler<ThirstSyncPacket, IMessage> {
    private float thirstLevel;
    private float thirstSaturation;
    private float exhaustion;

    public ThirstSyncPacket() {
    }

    public ThirstSyncPacket(IThirst thirst) {
        this.thirstLevel = thirst.getThirstLevel();
        this.thirstSaturation = thirst.getThirstSaturation();
        this.exhaustion = thirst.getExhaustion();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.thirstLevel);
        buf.writeFloat(this.thirstSaturation);
        buf.writeFloat(this.exhaustion);
    }

    public void fromBytes(ByteBuf buf) {
        this.thirstLevel = buf.readFloat();
        this.thirstSaturation = buf.readFloat();
        this.exhaustion = buf.readFloat();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(ThirstSyncPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                IThirst thirst;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null && (thirst = (IThirst)player.getCapability(ThirstProvider.THIRST_CAPABILITY, null)) != null) {
                    thirst.setThirstLevel(message.thirstLevel);
                    thirst.setThirstSaturation(message.thirstSaturation);
                    thirst.setExhaustion(message.exhaustion);
                }
            });
        }
        return null;
    }
}

