/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.TemperatureProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TemperatureSyncPacket
implements IMessage,
IMessageHandler<TemperatureSyncPacket, IMessage> {
    private double temperature;
    private double baseTemperature;

    public TemperatureSyncPacket() {
    }

    public TemperatureSyncPacket(ITemperature temperature) {
        this.temperature = temperature.getTemperature();
        this.baseTemperature = temperature.getBaseTemperature();
    }

    public void fromBytes(ByteBuf buf) {
        this.temperature = buf.readDouble();
        this.baseTemperature = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.temperature);
        buf.writeDouble(this.baseTemperature);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(TemperatureSyncPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                ITemperature temp;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null && (temp = (ITemperature)player.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null)) != null) {
                    temp.setTemperature(message.temperature);
                    temp.setBaseTemperature(message.baseTemperature);
                }
            });
        }
        return null;
    }
}

