/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.utils.TemperatureZones;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncTemperatureZonesPacket
implements IMessage,
IMessageHandler<SyncTemperatureZonesPacket, IMessage> {
    private int dimension;
    private List<ZoneData> zones;
    private boolean isValid = true;

    public SyncTemperatureZonesPacket() {
        this.zones = new ArrayList<ZoneData>();
    }

    public SyncTemperatureZonesPacket(int dimension, List<TemperatureZones.TemperatureZone> zones) {
        this.dimension = dimension;
        this.zones = new ArrayList<ZoneData>();
        if (zones != null) {
            for (TemperatureZones.TemperatureZone zone : zones) {
                this.zones.add(new ZoneData(zone.getName(), zone.getMinPos().func_177958_n(), zone.getMinPos().func_177956_o(), zone.getMinPos().func_177952_p(), zone.getMaxPos().func_177958_n(), zone.getMaxPos().func_177956_o(), zone.getMaxPos().func_177952_p(), zone.getTemperature(), zone.getBlendRadius(), zone.getPriority()));
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.dimension = buf.readInt();
            int count = buf.readInt();
            if (count < 0 || count > 1000) {
                this.isValid = false;
                return;
            }
            this.zones = new ArrayList<ZoneData>(count);
            for (int i = 0; i < count; ++i) {
                ZoneData data = new ZoneData();
                int nameLength = buf.readInt();
                if (nameLength < 0 || nameLength > 100) {
                    this.isValid = false;
                    return;
                }
                byte[] nameBytes = new byte[nameLength];
                buf.readBytes(nameBytes);
                data.name = new String(nameBytes, StandardCharsets.UTF_8);
                data.minX = buf.readInt();
                data.minY = buf.readInt();
                data.minZ = buf.readInt();
                data.maxX = buf.readInt();
                data.maxY = buf.readInt();
                data.maxZ = buf.readInt();
                data.temperature = buf.readDouble();
                data.blendRadius = buf.readDouble();
                data.priority = buf.readDouble();
                this.zones.add(data);
            }
        }
        catch (Exception e) {
            this.isValid = false;
            System.err.println("Erreur lors de la lecture du paquet SyncTemperatureZones: " + e.getMessage());
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            buf.writeInt(this.dimension);
            buf.writeInt(this.zones.size());
            for (ZoneData data : this.zones) {
                byte[] nameBytes = data.name.getBytes(StandardCharsets.UTF_8);
                buf.writeInt(nameBytes.length);
                buf.writeBytes(nameBytes);
                buf.writeInt(data.minX);
                buf.writeInt(data.minY);
                buf.writeInt(data.minZ);
                buf.writeInt(data.maxX);
                buf.writeInt(data.maxY);
                buf.writeInt(data.maxZ);
                buf.writeDouble(data.temperature);
                buf.writeDouble(data.blendRadius);
                buf.writeDouble(data.priority);
            }
        }
        catch (Exception e) {
            System.err.println("Erreur lors de l'\u00e9criture du paquet SyncTemperatureZones: " + e.getMessage());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(SyncTemperatureZonesPacket message, MessageContext ctx) {
        Minecraft mc;
        if (ctx.side.isClient() && message.isValid && (mc = Minecraft.func_71410_x()) != null) {
            mc.func_152344_a(() -> {
                try {
                    this.handlePacket(message);
                }
                catch (Exception e) {
                    System.err.println("Erreur lors du traitement du paquet SyncTemperatureZones: " + e.getMessage());
                }
            });
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handlePacket(SyncTemperatureZonesPacket message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        TemperatureZones.clearZonesForDimension(message.dimension);
        for (ZoneData data : message.zones) {
            BlockPos minPos = new BlockPos(data.minX, data.minY, data.minZ);
            BlockPos maxPos = new BlockPos(data.maxX, data.maxY, data.maxZ);
            TemperatureZones.addZone(message.dimension, new TemperatureZones.TemperatureZone(data.name, minPos, maxPos, data.temperature, data.blendRadius, data.priority));
        }
    }

    public static class ZoneData {
        String name;
        int minX;
        int minY;
        int minZ;
        int maxX;
        int maxY;
        int maxZ;
        double temperature;
        double blendRadius;
        double priority;

        public ZoneData() {
        }

        public ZoneData(String name, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double temperature, double blendRadius, double priority) {
            this.name = name;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.temperature = temperature;
            this.blendRadius = blendRadius;
            this.priority = priority;
        }
    }
}

