/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.api.stats.StatsUtils;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StatisticChangePacket
implements IMessage,
IMessageHandler<StatisticChangePacket, IMessage> {
    private Statistic statistic;

    public StatisticChangePacket() {
    }

    public StatisticChangePacket(Statistic statistic) {
        this.statistic = statistic;
    }

    public void fromBytes(ByteBuf buf) {
        this.statistic = Statistic.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.statistic.ordinal());
    }

    public IMessage onMessage(StatisticChangePacket message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            boolean availablePoints;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
            Statistic statistic = message.getStatistic();
            assert (stats != null);
            boolean bl = availablePoints = stats.getStatPoints() > 0;
            if (!availablePoints) {
                return null;
            }
            switch (statistic) {
                case SPEED: {
                    stats.setSpeed(stats.getSpeed() + 1);
                    stats.setStatPoints(stats.getStatPoints() - 1);
                    break;
                }
                case ENERGY: {
                    stats.setMaxEnergy(stats.getMaxEnergy() + 1);
                    stats.setStatPoints(stats.getStatPoints() - 1);
                    break;
                }
                case HEALTH: {
                    stats.setHP(stats.getHP() + 1);
                    stats.setStatPoints(stats.getStatPoints() - 1);
                    break;
                }
                case STRENGTH: {
                    stats.setStrength(stats.getStrength() + 1);
                    stats.setStatPoints(stats.getStatPoints() - 1);
                    break;
                }
                default: {
                    throw new RuntimeException("Could not find what statistic to upgrade!");
                }
            }
            stats.clientSync(player);
            StatsUtils.updateStats((EntityPlayer)player);
        }
        return null;
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public void setStatistic(Statistic statistic) {
        this.statistic = statistic;
    }

    public static enum Statistic {
        STRENGTH,
        SPEED,
        ENERGY,
        HEALTH;

    }
}

