/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerLevelUPPacket
implements IMessage,
IMessageHandler<PlayerLevelUPPacket, IMessage> {
    private int statToIncrease;

    public PlayerLevelUPPacket(int statToIncrease) {
        this.statToIncrease = statToIncrease;
    }

    public PlayerLevelUPPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.statToIncrease = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.statToIncrease);
    }

    public IMessage onMessage(PlayerLevelUPPacket message, MessageContext ctx) {
        EntityPlayerMP player;
        IMinePieceData cap;
        boolean canLevelUp;
        if (ctx.side.isServer() && (canLevelUp = PlayerUtils.canLevelUp((cap = (IMinePieceData)(player = ctx.getServerHandler().field_147369_b).getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)).getLevel(), cap.getXP()))) {
            cap.setLevel(cap.getLevel() + 1);
            IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
            switch (message.statToIncrease) {
                case 0: {
                    stats.setStrength(stats.getStrength() + 1);
                    break;
                }
                case 1: {
                    stats.setHP(stats.getHP() + 1);
                    break;
                }
                case 2: {
                    stats.setToughness(stats.getToughness() + 1);
                    break;
                }
                case 3: {
                    stats.setSpeed(stats.getSpeed() + 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + message.statToIncrease);
                }
            }
            stats.clientSync(player);
            cap.clientSync(player);
        }
        return null;
    }
}

