/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.knockout.IKOState;
import fr.minepiece.common.capability.knockout.KOStateStorage;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerKOSyncPacket
implements IMessage,
IMessageHandler<PlayerKOSyncPacket, IMessage> {
    private UUID playerUUID;
    private boolean isKO;

    public PlayerKOSyncPacket() {
    }

    public PlayerKOSyncPacket(UUID playerUUID, boolean isKO) {
        this.playerUUID = playerUUID;
        this.isKO = isKO;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.isKO = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        buf.writeBoolean(this.isKO);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PlayerKOSyncPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                world.field_73010_i.stream().filter(p -> p.func_110124_au().equals(message.playerUUID)).findFirst().ifPresent(player -> {
                    IKOState data = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
                    if (data != null) {
                        data.setKOState(message.isKO);
                    }
                });
            });
        }
        return null;
    }

    public static PlayerKOSyncPacket fromPlayer(EntityPlayerMP player, boolean isKO) {
        return new PlayerKOSyncPacket(player.func_110124_au(), isKO);
    }
}

