/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.init.ModSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayCustomSoundPacket
implements IMessage,
IMessageHandler<PlayCustomSoundPacket, IMessage> {
    private CustomSoundEnum customSoundEnum;
    private float volume;
    private float pitch;
    private boolean repeat;
    private int repeatDelay;
    private double posX;
    private double posY;
    private double posZ;

    public PlayCustomSoundPacket() {
    }

    public PlayCustomSoundPacket(CustomSoundEnum soundEnum, float volume, float pitch, boolean repeat, int repeatDelay, double posX, double posY, double posZ) {
        this.customSoundEnum = soundEnum;
        this.volume = volume;
        this.pitch = pitch;
        this.repeat = repeat;
        this.repeatDelay = repeatDelay;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void fromBytes(ByteBuf buf) {
        int enumIndex = buf.readInt();
        this.customSoundEnum = CustomSoundEnum.values()[enumIndex];
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.repeat = buf.readBoolean();
        this.repeatDelay = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.customSoundEnum.ordinal());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.repeat);
        buf.writeInt(this.repeatDelay);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public IMessage onMessage(PlayCustomSoundPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            this.playSound(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(PlayCustomSoundPacket message) {
        CustomSoundEnum soundEnum = message.customSoundEnum;
        SoundEvent soundEvent = soundEnum.getSound();
        float volume = message.volume;
        float pitch = message.pitch;
        boolean repeat = message.repeat;
        int repeatDelay = message.repeatDelay;
        float x = (float)message.posX;
        float y = (float)message.posY;
        float z = (float)message.posZ;
        PositionedSoundRecord sound = new PositionedSoundRecord(soundEvent.func_187503_a(), SoundCategory.MASTER, volume, pitch, repeat, repeatDelay, ISound.AttenuationType.LINEAR, x, y, z);
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_152344_a(() -> minecraft.func_147118_V().func_147682_a((ISound)sound));
    }

    public static enum CustomSoundEnum {
        CYBORG_LASER(ModSounds.CYBORG_LASER),
        HUMAN_SKYWALK(ModSounds.HUMAN_SKYWALK),
        FISHMAN_DROP(ModSounds.FISHMAN_WATER_DROP),
        WEAPONS_FLINTLOCK_RIFLE(ModSounds.WEAPONS_FLINTLOCK_RIFLE);

        private SoundEvent sound;

        private CustomSoundEnum(SoundEvent sound) {
            this.sound = sound;
        }

        public SoundEvent getSound() {
            return this.sound;
        }
    }
}

