/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.client.interactions.ClientController;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticleBlurPacket
implements IMessage,
IMessageHandler<ParticleBlurPacket, IMessage> {
    private String worldName;
    private Vec3d pos;
    private int life;
    private int color;
    private boolean alphaFading;
    private float scale;

    public ParticleBlurPacket() {
    }

    public ParticleBlurPacket(String worldName, Vec3d pos, int life, int color, boolean alphaFading, float scale) {
        this.worldName = worldName;
        this.life = life;
        this.pos = pos;
        this.color = color;
        this.alphaFading = alphaFading;
        this.scale = scale;
    }

    public void fromBytes(ByteBuf buf) {
        this.worldName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.life = buf.readInt();
        this.color = buf.readInt();
        this.alphaFading = buf.readBoolean();
        this.scale = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.worldName);
        buf.writeDouble(this.pos.field_72450_a);
        buf.writeDouble(this.pos.field_72448_b);
        buf.writeDouble(this.pos.field_72449_c);
        buf.writeInt(this.life);
        buf.writeInt(this.color);
        buf.writeBoolean(this.alphaFading);
        buf.writeFloat(this.scale);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(ParticleBlurPacket message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            this.handleClientParticle(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientParticle(ParticleBlurPacket message) {
        ClientController.handleEvent(ClientController.Events.SPAWN_BLUR_PARTICLE, message);
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Vec3d getPos() {
        return this.pos;
    }

    public double getX() {
        return this.pos.field_72450_a;
    }

    public double getY() {
        return this.pos.field_72448_b;
    }

    public double getZ() {
        return this.pos.field_72449_c;
    }

    public int getLife() {
        return this.life;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isAlphaFading() {
        return this.alphaFading;
    }

    public float getScale() {
        return this.scale;
    }
}

