/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.client.render.ShaderHelper;
import fr.minepiece.client.render.shaders.SmokeCloudClientData;
import fr.minepiece.client.render.sphere.SphereCallback;
import fr.minepiece.client.render.sphere.SphereManager;
import fr.minepiece.client.render.sphere.SphereRenderObject;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSpawnSmokeCloud
implements IMessage,
IMessageHandler<PacketSpawnSmokeCloud, IMessage> {
    UUID id;
    double x;
    double y;
    double z;
    float radius;
    int color;
    float density;
    int duration;

    public PacketSpawnSmokeCloud() {
    }

    public PacketSpawnSmokeCloud(UUID id, double x, double y, double z, float radius, int color, float density, int duration) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.color = color;
        this.density = density;
        this.duration = duration;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.radius = buf.readFloat();
        this.color = buf.readInt();
        this.density = buf.readFloat();
        this.duration = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id.toString());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.radius);
        buf.writeInt(this.color);
        buf.writeFloat(this.density);
        buf.writeInt(this.duration);
    }

    public IMessage onMessage(PacketSpawnSmokeCloud message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            long expiry = Minecraft.func_71410_x().field_71441_e.func_82737_E() + (long)message.duration;
            float r = (float)(message.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(message.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(message.color & 0xFF) / 255.0f;
            SphereRenderObject object = new SphereRenderObject(5.0f, new Vec3d(message.x, message.y, message.z), new float[]{r, g, b, 0.75f}, new SphereCallback(){

                @Override
                public void callback(SphereRenderObject object, Side side) {
                }
            }, message.duration, ShaderHelper.smokeFogShader);
            SphereManager.addFullSphere(object);
            SmokeCloudClientData.activeClouds.put(String.valueOf(message.id), new SmokeCloudClientData(new Vec3d(message.x, message.y, message.z), message.radius, r, g, b, message.density, expiry));
        });
        return null;
    }
}

