/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.entity.EntityBarque;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBarqueMotion
implements IMessage,
IMessageHandler<PacketBarqueMotion, IMessage> {
    private int entityId;
    private double motionX;
    private double motionY;
    private double motionZ;

    public PacketBarqueMotion() {
    }

    public PacketBarqueMotion(int entityId, double motionX, double motionY, double motionZ) {
        this.entityId = entityId;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.motionX = buf.readDouble();
        this.motionY = buf.readDouble();
        this.motionZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
    }

    public IMessage onMessage(PacketBarqueMotion message, MessageContext ctx) {
        WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
        world.func_152344_a(() -> {
            Entity entity = world.func_73045_a(message.entityId);
            if (entity instanceof EntityBarque) {
                EntityBarque barque = (EntityBarque)entity;
                barque.field_70159_w = message.motionX;
                barque.field_70181_x = message.motionY;
                barque.field_70179_y = message.motionZ;
                SPacketEntityVelocity velocityPacket = new SPacketEntityVelocity(barque.func_145782_y(), barque.field_70159_w, barque.field_70181_x, barque.field_70179_y);
                System.out.println("SENDING VELOCITY PACKET: " + this.motionX + ", " + this.motionY + ", " + this.motionZ);
                for (EntityPlayer player : world.func_73039_n().getTrackingPlayers((Entity)barque)) {
                    if (player == ctx.getServerHandler().field_147369_b) continue;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)velocityPacket);
                }
            }
        });
        return null;
    }
}

