/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.network.packets;

import fr.minepiece.common.capability.CapabilityHelper;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ModificationSyncPacket
implements IMessage,
IMessageHandler<ModificationSyncPacket, IMessage> {
    private ArrayList<String> modifications;
    private ArrayList<String> skinModifications;
    private String pose;
    private String skin;
    private int skinColor;
    private int modificationColor;

    public ModificationSyncPacket(ArrayList<String> modifications, ArrayList<String> skinModifications, String pose, String skin, int skinColor, int modificationColor) {
        this.modifications = modifications;
        this.skinModifications = skinModifications;
        this.pose = pose;
        this.skin = skin;
        this.skinColor = skinColor;
        this.modificationColor = modificationColor;
    }

    public ModificationSyncPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.skinColor = buf.readInt();
        this.modificationColor = buf.readInt();
        int size = buf.readInt();
        this.modifications = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.modifications.add(name);
        }
        int skinSize = buf.readInt();
        this.skinModifications = new ArrayList(skinSize);
        for (int i = 0; i < skinSize; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.skinModifications.add(name);
        }
        this.pose = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.skin = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.skinColor);
        buf.writeInt(this.modificationColor);
        buf.writeInt(this.modifications.size());
        for (String modificationName : this.modifications) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)modificationName);
        }
        buf.writeInt(this.skinModifications.size());
        for (String modificationName : this.skinModifications) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)modificationName);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.pose);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skin);
    }

    public IMessage onMessage(ModificationSyncPacket message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                IPlayerModifications modificationsCapability = CapabilityHelper.getPlayerModifications((EntityPlayer)ctx.getServerHandler().field_147369_b);
                modificationsCapability.setSkinModifications(new ArrayList<String>(message.skinModifications));
                modificationsCapability.setModifications(new ArrayList<String>(message.modifications));
                modificationsCapability.setPose(message.pose);
                modificationsCapability.setSkin(message.skin);
                modificationsCapability.setSkinColor(message.skinColor);
                modificationsCapability.setModificationColor(message.modificationColor);
                modificationsCapability.clientSync(ctx.getServerHandler().field_147369_b);
            });
        }
        return null;
    }
}

